/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkerShorthandResolver.class);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("marker-start", shorthandExpression), new CssDeclaration("marker-mid", shorthandExpression), new CssDeclaration("marker-end", shorthandExpression));
        }
        String expression = shorthandExpression.trim();
        if (expression.isEmpty()) {
            LOGGER.warn(MessageFormatUtil.format("{0} shorthand property cannot be empty.", "marker"));
            return new ArrayList<CssDeclaration>();
        }
        if (!expression.startsWith("url(") || !expression.endsWith(")")) {
            LOGGER.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", shorthandExpression));
            return new ArrayList<CssDeclaration>();
        }
        return Arrays.asList(new CssDeclaration("marker-start", shorthandExpression), new CssDeclaration("marker-mid", shorthandExpression), new CssDeclaration("marker-end", shorthandExpression));
    }
}

