/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GridItemShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridItemShorthandResolver.class);
    private final String propertyTemplate;

    protected GridItemShorthandResolver(String shorthand) {
        this.propertyTemplate = shorthand + "-{0}";
    }

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if ((shorthandExpression = shorthandExpression.trim()).isEmpty()) {
            LOGGER.warn(MessageFormatUtil.format("{0} shorthand property cannot be empty.", this.propertyTemplate.substring(0, this.propertyTemplate.length() - 4)));
            return new ArrayList<CssDeclaration>();
        }
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression) || "auto".equals(shorthandExpression)) {
            return new ArrayList<CssDeclaration>();
        }
        String[] values = shorthandExpression.split("/");
        if (values.length == 1) {
            if (shorthandExpression.startsWith("span")) {
                return Collections.singletonList(new CssDeclaration(MessageFormatUtil.format(this.propertyTemplate, "start"), values[0]));
            }
            return Arrays.asList(new CssDeclaration(MessageFormatUtil.format(this.propertyTemplate, "start"), values[0]), new CssDeclaration(MessageFormatUtil.format(this.propertyTemplate, "end"), values[0]));
        }
        return Arrays.asList(new CssDeclaration(MessageFormatUtil.format(this.propertyTemplate, "start"), values[0]), new CssDeclaration(MessageFormatUtil.format(this.propertyTemplate, "end"), values[1]));
    }
}

