/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IBasicOCSPResponse;
import com.itextpdf.commons.bouncycastle.asn1.tsp.ITSTInfo;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.SignatureUtil;
import com.itextpdf.signatures.validation.CertificateChainValidator;
import com.itextpdf.signatures.validation.DocumentRevisionsValidator;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.ValidationCrlClient;
import com.itextpdf.signatures.validation.ValidationMetaInfo;
import com.itextpdf.signatures.validation.ValidationOcspClient;
import com.itextpdf.signatures.validation.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.context.CertificateSource;
import com.itextpdf.signatures.validation.context.TimeBasedContext;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.context.ValidatorContext;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SignatureValidator {
    public static final String VALIDATING_SIGNATURE_NAME = "Validating signature {0}";
    static final String TIMESTAMP_VERIFICATION = "Timestamp verification check.";
    static final String SIGNATURE_VERIFICATION = "Signature verification check.";
    static final String CANNOT_PARSE_CERT_FROM_DSS = "Certificate {0} stored in DSS dictionary cannot be parsed.";
    static final String CANNOT_PARSE_OCSP_FROM_DSS = "OCSP response {0} stored in DSS dictionary cannot be parsed.";
    static final String CANNOT_PARSE_CRL_FROM_DSS = "CRL {0} stored in DSS dictionary cannot be parsed.";
    static final String CANNOT_VERIFY_SIGNATURE = "Signature {0} cannot be mathematically verified.";
    static final String DOCUMENT_IS_NOT_COVERED = "Signature {0} doesn't cover entire document.";
    static final String CANNOT_VERIFY_TIMESTAMP = "Signature timestamp attribute cannot be verified.";
    static final String TIMESTAMP_VERIFICATION_FAILED = "Unexpected exception occurred during mathematical verification of time stamp signature.";
    static final String REVISIONS_RETRIEVAL_FAILED = "Unexpected exception occurred during document revisions retrieval.";
    static final String TIMESTAMP_EXTRACTION_FAILED = "Unexpected exception occurred retrieving prove of existence from timestamp signature";
    static final String CHAIN_VALIDATION_FAILED = "Unexpected exception occurred during certificate chain validation.";
    static final String REVISIONS_VALIDATION_FAILED = "Unexpected exception occurred during revisions validation.";
    static final String ADD_KNOWN_CERTIFICATES_FAILED = "Unexpected exception occurred adding known certificates to certificate retriever.";
    static final String SIGNATURE_NOT_FOUND = "Document doesn't contain signature field {0}.";
    static final String VALIDATION_PERFORMED = "Validation has already been performed. You should create new SignatureValidator instance for each validation call.";
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final ValidatorChainBuilder builder;
    private ValidationContext validationContext = new ValidationContext(ValidatorContext.SIGNATURE_VALIDATOR, CertificateSource.SIGNER_CERT, TimeBasedContext.PRESENT);
    private final CertificateChainValidator certificateChainValidator;
    private final DocumentRevisionsValidator documentRevisionsValidator;
    private final IssuingCertificateRetriever certificateRetriever;
    private final SignatureValidationProperties properties;
    private Date lastKnownPoE = DateTimeUtil.getCurrentTimeDate();
    private IMetaInfo metaInfo = new ValidationMetaInfo();
    private final PdfDocument originalDocument;
    private ValidationOcspClient validationOcspClient;
    private ValidationCrlClient validationCrlClient;
    private boolean validationPerformed = false;

    protected SignatureValidator(PdfDocument originalDocument, ValidatorChainBuilder builder) {
        this.originalDocument = originalDocument;
        this.builder = builder;
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.certificateChainValidator = builder.getCertificateChainValidator();
        this.documentRevisionsValidator = builder.getDocumentRevisionsValidator();
        this.findValidationClients();
    }

    public SignatureValidator setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    public ValidationReport validateSignatures() {
        if (this.validationPerformed) {
            throw new PdfException(VALIDATION_PERFORMED);
        }
        this.validationPerformed = true;
        ValidationReport report = new ValidationReport();
        SafeCalling.onRuntimeExceptionLog(() -> {
            this.documentRevisionsValidator.setEventCountingMetaInfo(this.metaInfo);
            ValidationReport revisionsValidationReport = this.documentRevisionsValidator.validateAllDocumentRevisions(this.validationContext, this.originalDocument);
            report.merge(revisionsValidationReport);
        }, report, e -> new ReportItem(SIGNATURE_VERIFICATION, REVISIONS_VALIDATION_FAILED, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
        if (this.stopValidation(report, this.validationContext)) {
            return report;
        }
        return report.merge(this.validate(null));
    }

    public ValidationReport validateSignature(String signatureName) {
        if (this.validationPerformed) {
            throw new PdfException(VALIDATION_PERFORMED);
        }
        this.validationPerformed = true;
        ValidationReport report = new ValidationReport();
        SafeCalling.onRuntimeExceptionLog(() -> {
            this.documentRevisionsValidator.setEventCountingMetaInfo(this.metaInfo);
            ValidationReport revisionsValidationReport = this.documentRevisionsValidator.validateAllDocumentRevisions(this.validationContext, this.originalDocument, signatureName);
            report.merge(revisionsValidationReport);
        }, report, e -> new ReportItem(SIGNATURE_VERIFICATION, REVISIONS_VALIDATION_FAILED, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
        if (this.stopValidation(report, this.validationContext)) {
            return report;
        }
        return report.merge(this.validate(signatureName));
    }

    ValidationReport validateLatestSignature(PdfDocument document) {
        ValidationReport validationReport = new ValidationReport();
        PdfPKCS7 pkcs7 = this.mathematicallyVerifySignature(validationReport, document);
        this.updateValidationClients(pkcs7, validationReport, this.validationContext, document);
        this.retrieveNotSignedRevocationInfoFromSignatureContainer(pkcs7, this.validationContext);
        if (this.stopValidation(validationReport, this.validationContext)) {
            this.reportResult(validationReport);
            return validationReport;
        }
        List<Certificate> certificatesFromDss = this.getCertificatesFromDss(validationReport, document);
        SafeCalling.onRuntimeExceptionLog(() -> this.certificateRetriever.addKnownCertificates(certificatesFromDss), validationReport, e -> new ReportItem(SIGNATURE_VERIFICATION, ADD_KNOWN_CERTIFICATES_FAILED, (Exception)e, ReportItem.ReportItemStatus.INFO));
        if (pkcs7.isTsp()) {
            this.validateTimestampChain(validationReport, pkcs7.getCertificates(), pkcs7.getSigningCertificate());
            if (this.updateLastKnownPoE(validationReport, pkcs7.getTimeStampTokenInfo())) {
                this.updateValidationClients(pkcs7, validationReport, this.validationContext, document);
            }
            this.reportResult(validationReport);
            return validationReport;
        }
        boolean isPoEUpdated = false;
        Date previousLastKnowPoE = this.lastKnownPoE;
        ValidationContext previousValidationContext = this.validationContext;
        if (pkcs7.getTimeStampTokenInfo() != null) {
            ValidationReport tsValidationReport = this.validateEmbeddedTimestamp(pkcs7);
            isPoEUpdated = this.updateLastKnownPoE(tsValidationReport, pkcs7.getTimeStampTokenInfo());
            if (isPoEUpdated) {
                PdfPKCS7 timestampSignatureContainer = pkcs7.getTimestampSignatureContainer();
                this.retrieveSignedRevocationInfoFromSignatureContainer(timestampSignatureContainer, this.validationContext);
                this.updateValidationClients(pkcs7, tsValidationReport, this.validationContext, document);
            }
            validationReport.merge(tsValidationReport);
            if (this.stopValidation(tsValidationReport, this.validationContext)) {
                this.reportResult(validationReport);
                return validationReport;
            }
        }
        Certificate[] certificates = pkcs7.getCertificates();
        SafeCalling.onRuntimeExceptionLog(() -> this.certificateRetriever.addKnownCertificates(Arrays.asList(certificates)), validationReport, e -> new ReportItem(SIGNATURE_VERIFICATION, ADD_KNOWN_CERTIFICATES_FAILED, (Exception)e, ReportItem.ReportItemStatus.INFO));
        X509Certificate signingCertificate = pkcs7.getSigningCertificate();
        ValidationReport signatureReport = new ValidationReport();
        SafeCalling.onExceptionLog(() -> this.certificateChainValidator.validate(signatureReport, this.validationContext, signingCertificate, this.lastKnownPoE), validationReport, e -> new CertificateReportItem(signingCertificate, SIGNATURE_VERIFICATION, CHAIN_VALIDATION_FAILED, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
        if (isPoEUpdated && signatureReport.getValidationResult() != ValidationReport.ValidationResult.VALID) {
            this.lastKnownPoE = previousLastKnowPoE;
            this.validationContext = previousValidationContext;
            PdfPKCS7 timestampSignatureContainer = pkcs7.getTimestampSignatureContainer();
            this.retrieveSignedRevocationInfoFromSignatureContainer(timestampSignatureContainer, this.validationContext);
            this.updateValidationClients(pkcs7, validationReport, this.validationContext, document);
        }
        this.reportResult(validationReport);
        return validationReport.merge(signatureReport);
    }

    private void reportResult(ValidationReport validationReport) {
        if (validationReport.getValidationResult() == ValidationReport.ValidationResult.VALID) {
            this.builder.getAdESReportAggregator().reportSignatureValidationSuccess();
            return;
        }
        StringBuilder reason = new StringBuilder("[");
        for (ReportItem reportItem : validationReport.getFailures()) {
            reason.append(reportItem).append("\n");
        }
        reason.append("]");
        this.builder.getAdESReportAggregator().reportSignatureValidationFailure(validationReport.getValidationResult() == ValidationReport.ValidationResult.INDETERMINATE, reason.toString());
    }

    private ValidationReport validate(String signatureName) {
        ValidationReport validationReport = new ValidationReport();
        boolean validateSingleSignature = signatureName != null;
        SignatureUtil util = new SignatureUtil(this.originalDocument);
        List<String> signatureNames = util.getSignatureNames();
        Collections.reverse(signatureNames);
        for (String fieldName : signatureNames) {
            ValidationReport subReport = new ValidationReport();
            try (PdfDocument doc = new PdfDocument(new PdfReader(util.extractRevision(fieldName), this.originalDocument.getReader().getPropertiesCopy()).setStrictnessLevel(PdfReader.StrictnessLevel.CONSERVATIVE), new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
                subReport.merge(this.validateLatestSignature(doc));
            }
            catch (IOException | RuntimeException e) {
                subReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, REVISIONS_RETRIEVAL_FAILED, e, ReportItem.ReportItemStatus.INDETERMINATE));
            }
            if (!validateSingleSignature) {
                validationReport.merge(subReport);
                if (!this.stopValidation(subReport, this.validationContext)) continue;
                return validationReport;
            }
            if (!fieldName.equals(signatureName)) continue;
            return subReport;
        }
        if (validateSingleSignature) {
            validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(SIGNATURE_NOT_FOUND, signatureName), ReportItem.ReportItemStatus.INDETERMINATE));
        }
        return validationReport;
    }

    private void findValidationClients() {
        for (IOcspClient ocspClient : this.properties.getOcspClients()) {
            if (ocspClient.getClass() != ValidationOcspClient.class) continue;
            this.validationOcspClient = (ValidationOcspClient)ocspClient;
            break;
        }
        for (ICrlClient crlClient : this.properties.getCrlClients()) {
            if (crlClient.getClass() != ValidationCrlClient.class) continue;
            this.validationCrlClient = (ValidationCrlClient)crlClient;
            break;
        }
    }

    private PdfPKCS7 mathematicallyVerifySignature(ValidationReport validationReport, PdfDocument document) {
        SignatureUtil signatureUtil = new SignatureUtil(document);
        List<String> signatures = signatureUtil.getSignatureNames();
        String latestSignatureName = signatures.get(signatures.size() - 1);
        PdfPKCS7 pkcs7 = signatureUtil.readSignatureData(latestSignatureName);
        validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(VALIDATING_SIGNATURE_NAME, latestSignatureName), ReportItem.ReportItemStatus.INFO));
        if (pkcs7.isTsp()) {
            this.builder.getAdESReportAggregator().proofOfExistenceFound(signatureUtil.getSignature(latestSignatureName).getContents().getValueBytes(), true);
        } else {
            this.builder.getAdESReportAggregator().startSignatureValidation(signatureUtil.getSignature(latestSignatureName).getContents().getValueBytes(), latestSignatureName, this.lastKnownPoE);
        }
        if (!signatureUtil.signatureCoversWholeDocument(latestSignatureName)) {
            validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(DOCUMENT_IS_NOT_COVERED, latestSignatureName), ReportItem.ReportItemStatus.INVALID));
        }
        try {
            if (!pkcs7.verifySignatureIntegrityAndAuthenticity()) {
                validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(CANNOT_VERIFY_SIGNATURE, latestSignatureName), ReportItem.ReportItemStatus.INVALID));
            }
        }
        catch (RuntimeException | GeneralSecurityException e) {
            validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(CANNOT_VERIFY_SIGNATURE, latestSignatureName), e, ReportItem.ReportItemStatus.INVALID));
        }
        return pkcs7;
    }

    private ValidationReport validateEmbeddedTimestamp(PdfPKCS7 pkcs7) {
        ValidationReport tsValidationReport = new ValidationReport();
        try {
            if (!pkcs7.verifyTimestampImprint()) {
                tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, CANNOT_VERIFY_TIMESTAMP, ReportItem.ReportItemStatus.INVALID));
            }
        }
        catch (GeneralSecurityException e) {
            tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, CANNOT_VERIFY_TIMESTAMP, e, ReportItem.ReportItemStatus.INVALID));
        }
        catch (RuntimeException e) {
            tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION_FAILED, TIMESTAMP_VERIFICATION_FAILED, e, ReportItem.ReportItemStatus.INVALID));
        }
        if (this.stopValidation(tsValidationReport, this.validationContext)) {
            return tsValidationReport;
        }
        PdfPKCS7 timestampSignatureContainer = pkcs7.getTimestampSignatureContainer();
        this.retrieveSignedRevocationInfoFromSignatureContainer(timestampSignatureContainer, this.validationContext);
        try {
            if (!timestampSignatureContainer.verifySignatureIntegrityAndAuthenticity()) {
                tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, CANNOT_VERIFY_TIMESTAMP, ReportItem.ReportItemStatus.INVALID));
            }
        }
        catch (GeneralSecurityException e) {
            tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, CANNOT_VERIFY_TIMESTAMP, e, ReportItem.ReportItemStatus.INVALID));
        }
        catch (RuntimeException e) {
            tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION_FAILED, TIMESTAMP_VERIFICATION_FAILED, e, ReportItem.ReportItemStatus.INVALID));
        }
        if (this.stopValidation(tsValidationReport, this.validationContext)) {
            return tsValidationReport;
        }
        Certificate[] timestampCertificates = timestampSignatureContainer.getCertificates();
        this.validateTimestampChain(tsValidationReport, timestampCertificates, timestampSignatureContainer.getSigningCertificate());
        return tsValidationReport;
    }

    private void validateTimestampChain(ValidationReport validationReport, Certificate[] knownCerts, X509Certificate signingCert) {
        SafeCalling.onExceptionLog(() -> this.certificateRetriever.addKnownCertificates(Arrays.asList(knownCerts)), validationReport, e -> new ReportItem(SIGNATURE_VERIFICATION, ADD_KNOWN_CERTIFICATES_FAILED, (Exception)e, ReportItem.ReportItemStatus.INFO));
        try {
            this.certificateChainValidator.validate(validationReport, this.validationContext.setCertificateSource(CertificateSource.TIMESTAMP), signingCert, this.lastKnownPoE);
        }
        catch (RuntimeException e2) {
            validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, CHAIN_VALIDATION_FAILED, e2, ReportItem.ReportItemStatus.INFO));
        }
    }

    private boolean updateLastKnownPoE(ValidationReport tsValidationReport, ITSTInfo timeStampTokenInfo) {
        if (tsValidationReport.getValidationResult() == ValidationReport.ValidationResult.VALID) {
            try {
                this.lastKnownPoE = timeStampTokenInfo.getGenTime();
                if (this.validationContext.getTimeBasedContext() == TimeBasedContext.PRESENT) {
                    this.validationContext = this.validationContext.setTimeBasedContext(TimeBasedContext.HISTORICAL);
                }
                return true;
            }
            catch (Exception e) {
                tsValidationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, TIMESTAMP_EXTRACTION_FAILED, e, ReportItem.ReportItemStatus.INDETERMINATE));
            }
        }
        return false;
    }

    private void updateValidationClients(PdfPKCS7 pkcs7, ValidationReport validationReport, ValidationContext validationContext, PdfDocument document) {
        this.retrieveOcspResponsesFromDss(validationReport, validationContext, document);
        this.retrieveCrlResponsesFromDss(validationReport, validationContext, document);
        this.retrieveSignedRevocationInfoFromSignatureContainer(pkcs7, validationContext);
    }

    private void retrieveSignedRevocationInfoFromSignatureContainer(PdfPKCS7 pkcs7, ValidationContext validationContext) {
        if (pkcs7.getCRLs() != null) {
            for (CRL crl : pkcs7.getCRLs()) {
                this.validationCrlClient.addCrl((X509CRL)crl, this.lastKnownPoE, validationContext.getTimeBasedContext());
            }
        }
        if (pkcs7.getOcsp() != null) {
            this.validationOcspClient.addResponse(BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(pkcs7.getOcsp()), this.lastKnownPoE, validationContext.getTimeBasedContext());
        }
    }

    private void retrieveNotSignedRevocationInfoFromSignatureContainer(PdfPKCS7 pkcs7, ValidationContext validationContext) {
        for (CRL crl : pkcs7.getSignedDataCRLs()) {
            this.validationCrlClient.addCrl((X509CRL)crl, this.lastKnownPoE, validationContext.getTimeBasedContext());
        }
        for (IBasicOCSPResponse oscp : pkcs7.getSignedDataOcsps()) {
            this.validationOcspClient.addResponse(BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(oscp), this.lastKnownPoE, validationContext.getTimeBasedContext());
        }
    }

    private void retrieveOcspResponsesFromDss(ValidationReport validationReport, ValidationContext context, PdfDocument document) {
        PdfArray ocsps;
        PdfDictionary dss = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        if (dss != null && (ocsps = dss.getAsArray(PdfName.OCSPs)) != null) {
            for (int i = 0; i < ocsps.size(); ++i) {
                PdfStream ocspStream = ocsps.getAsStream(i);
                try {
                    this.validationOcspClient.addResponse(BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(BOUNCY_CASTLE_FACTORY.createOCSPResp(ocspStream.getBytes()).getResponseObject()), this.lastKnownPoE, context.getTimeBasedContext());
                    continue;
                }
                catch (AbstractOCSPException | IOException | RuntimeException e) {
                    validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(CANNOT_PARSE_OCSP_FROM_DSS, ocspStream), e, ReportItem.ReportItemStatus.INFO));
                }
            }
        }
    }

    private void retrieveCrlResponsesFromDss(ValidationReport validationReport, ValidationContext context, PdfDocument document) {
        PdfArray crls;
        PdfDictionary dss = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        if (dss != null && (crls = dss.getAsArray(PdfName.CRLs)) != null) {
            for (int i = 0; i < crls.size(); ++i) {
                PdfStream crlStream = crls.getAsStream(i);
                SafeCalling.onExceptionLog(() -> this.validationCrlClient.addCrl((X509CRL)CertificateUtil.parseCrlFromBytes(crlStream.getBytes()), this.lastKnownPoE, context.getTimeBasedContext()), validationReport, e -> new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(CANNOT_PARSE_CRL_FROM_DSS, crlStream), (Exception)e, ReportItem.ReportItemStatus.INFO));
            }
        }
    }

    private List<Certificate> getCertificatesFromDss(ValidationReport validationReport, PdfDocument document) {
        PdfArray certs;
        PdfDictionary dss = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        ArrayList<Certificate> certificatesFromDss = new ArrayList<Certificate>();
        if (dss != null && (certs = dss.getAsArray(PdfName.Certs)) != null) {
            for (int i = 0; i < certs.size(); ++i) {
                PdfStream certStream = certs.getAsStream(i);
                try {
                    certificatesFromDss.add(CertificateUtil.generateCertificate(new ByteArrayInputStream(certStream.getBytes())));
                    continue;
                }
                catch (RuntimeException | GeneralSecurityException e) {
                    validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format(CANNOT_PARSE_CERT_FROM_DSS, certStream), e, ReportItem.ReportItemStatus.INFO));
                }
            }
        }
        return certificatesFromDss;
    }

    private boolean stopValidation(ValidationReport result, ValidationContext validationContext) {
        return !this.properties.getContinueAfterFailure(validationContext) && result.getValidationResult() == ValidationReport.ValidationResult.INVALID;
    }
}

