/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import java.util.ArrayList;
import java.util.List;

public class SignaturePermissions {
    boolean certification = false;
    boolean fillInAllowed = true;
    boolean annotationsAllowed = true;
    List<FieldLock> fieldLocks = new ArrayList<FieldLock>();

    public SignaturePermissions(PdfDictionary sigDict, SignaturePermissions previous) {
        PdfArray ref;
        if (previous != null) {
            this.annotationsAllowed &= previous.isAnnotationsAllowed();
            this.fillInAllowed &= previous.isFillInAllowed();
            this.fieldLocks.addAll(previous.getFieldLocks());
        }
        if ((ref = sigDict.getAsArray(PdfName.Reference)) != null) {
            block4: for (int i = 0; i < ref.size(); ++i) {
                PdfNumber p;
                PdfName action;
                PdfDictionary dict = ref.getAsDictionary(i);
                PdfDictionary params = dict.getAsDictionary(PdfName.TransformParams);
                if (PdfName.DocMDP.equals(dict.getAsName(PdfName.TransformMethod))) {
                    this.certification = true;
                }
                if ((action = params.getAsName(PdfName.Action)) != null) {
                    this.fieldLocks.add(new FieldLock(action, params.getAsArray(PdfName.Fields)));
                }
                if ((p = params.getAsNumber(PdfName.P)) == null) continue;
                switch (p.intValue()) {
                    default: {
                        continue block4;
                    }
                    case 1: {
                        this.fillInAllowed &= false;
                    }
                    case 2: {
                        this.annotationsAllowed &= false;
                    }
                }
            }
        }
    }

    public boolean isCertification() {
        return this.certification;
    }

    public boolean isFillInAllowed() {
        return this.fillInAllowed;
    }

    public boolean isAnnotationsAllowed() {
        return this.annotationsAllowed;
    }

    public List<FieldLock> getFieldLocks() {
        return this.fieldLocks;
    }

    public class FieldLock {
        PdfName action;
        PdfArray fields;

        public FieldLock(PdfName action, PdfArray fields) {
            this.action = action;
            this.fields = fields;
        }

        public PdfName getAction() {
            return this.action;
        }

        public PdfArray getFields() {
            return this.fields;
        }

        public String toString() {
            return this.action.toString() + (this.fields == null ? "" : this.fields.toString());
        }
    }
}

