/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.kernel.crypto.DigestAlgorithms;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.IApplicableSignatureParams;
import com.itextpdf.signatures.SignUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.Signature;

public class RSASSAPSSMechanismParams
implements IApplicableSignatureParams {
    public static final int DEFAULT_TRAILER_FIELD = 1;
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final IASN1ObjectIdentifier digestAlgoOid;
    private final int saltLen;
    private final int trailerField;

    public RSASSAPSSMechanismParams(IASN1ObjectIdentifier digestAlgoOid, int saltLen, int trailerField) {
        this.digestAlgoOid = digestAlgoOid;
        this.saltLen = saltLen;
        this.trailerField = trailerField;
    }

    public static RSASSAPSSMechanismParams createForDigestAlgorithm(String digestAlgorithmName) {
        String oid = DigestAlgorithms.getAllowedDigest(digestAlgorithmName);
        IASN1ObjectIdentifier oidWrapper = FACTORY.createASN1ObjectIdentifier(oid);
        int bitLen = DigestAlgorithms.getOutputBitLength(digestAlgorithmName);
        return new RSASSAPSSMechanismParams(oidWrapper, bitLen / 8, 1);
    }

    @Override
    public IASN1Encodable toEncodable() {
        return FACTORY.createRSASSAPSSParamsWithMGF1(this.digestAlgoOid, this.saltLen, this.trailerField);
    }

    @Override
    public void apply(Signature signature) {
        try {
            SignUtils.setRSASSAPSSParamsWithMGF1(signature, DigestAlgorithms.getDigest(this.digestAlgoOid.getId()), this.saltLen, this.trailerField);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PdfException(e);
        }
    }
}

