/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.SignUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlClientOnline
implements ICrlClient {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(CrlClientOnline.class);
    protected List<URL> urls = new ArrayList<URL>();

    public CrlClientOnline() {
    }

    public CrlClientOnline(String ... crls) {
        for (String url : crls) {
            this.addUrl(url);
        }
    }

    public CrlClientOnline(URL ... crls) {
        for (URL url : crls) {
            this.addUrl(url);
        }
    }

    public CrlClientOnline(Certificate[] chain) {
        for (Certificate certificate : chain) {
            X509Certificate cert = (X509Certificate)certificate;
            LOGGER.info("Checking certificate: " + cert.getSubjectDN());
            List<String> urls = CertificateUtil.getCRLURLs(cert);
            for (String url : urls) {
                this.addUrl(url);
            }
        }
    }

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) throws CertificateEncodingException {
        if (checkCert == null) {
            return null;
        }
        ArrayList<URL> urlList = new ArrayList<URL>(this.urls);
        if (urlList.isEmpty()) {
            LOGGER.info(MessageFormatUtil.format("Looking for CRL for certificate {0}", BOUNCY_CASTLE_FACTORY.createX500Name(checkCert)));
            try {
                List<Object> urlsList = new ArrayList<String>();
                if (url == null) {
                    urlsList = CertificateUtil.getCRLURLs(checkCert);
                } else {
                    urlsList.add(url);
                }
                if (urlsList.isEmpty()) {
                    throw new IllegalArgumentException("Passed url can not be null.");
                }
                for (String string : urlsList) {
                    urlList.add(new URL(string));
                    LOGGER.info("Found CRL url: " + string);
                }
            }
            catch (Exception e) {
                LOGGER.info("Skipped CRL url: " + e.getMessage());
            }
        }
        ArrayList<byte[]> ar = new ArrayList<byte[]>();
        for (URL uRL : urlList) {
            try {
                int n;
                LOGGER.info("Checking CRL: " + uRL);
                InputStream inp = this.getCrlResponse(checkCert, uRL);
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((n = inp.read(buf, 0, buf.length)) > 0) {
                    bout.write(buf, 0, n);
                }
                inp.close();
                ar.add(bout.toByteArray());
                LOGGER.info("Added CRL found at: " + uRL);
            }
            catch (Exception e) {
                LOGGER.info(MessageFormatUtil.format("Skipped CRL: {0}", e.getMessage()));
            }
        }
        return ar;
    }

    protected InputStream getCrlResponse(X509Certificate cert, URL urlt) throws IOException {
        return SignUtils.getHttpResponse(urlt);
    }

    protected void addUrl(String url) {
        try {
            this.addUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            LOGGER.info("Skipped CRL url (malformed): " + url);
        }
    }

    protected void addUrl(URL url) {
        if (this.urls.contains(url)) {
            LOGGER.info("Skipped CRL url (duplicate): " + url);
            return;
        }
        this.urls.add(url);
        LOGGER.info("Added CRL url: " + url);
    }

    public int getUrlsSize() {
        return this.urls.size();
    }
}

