/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA2NotesChecker {
    private final PdfUAValidationContext context;

    private PdfUA2NotesChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkStructElement(IStructureNode elem) {
        String role = this.context.resolveToStandardRole(elem);
        if (role == null) {
            return;
        }
        if ("Note".equals(role)) {
            throw new PdfUAConformanceException("Document uses Note tag: conforming files shall not use Note structure type. Instead FENote structure type shall be used.");
        }
        PdfStructElem noteStructElem = this.context.getElementIfRoleMatches(PdfName.FENote, elem);
        if (noteStructElem == null) {
            PdfStructElem structElem;
            if (elem instanceof PdfStructElem && !(structElem = (PdfStructElem)elem).getRefsList().stream().filter(reference -> "FENote".equals(this.context.resolveToStandardRole((IStructureNode)reference))).allMatch(reference -> reference.getRefsList().stream().anyMatch(innerRef -> ((PdfDictionary)innerRef.getPdfObject()).equals(structElem.getPdfObject())))) {
                throw new PdfUAConformanceException("FENote structure element shall use the Ref entry to identify all citations that reference it.");
            }
        } else {
            if (!noteStructElem.getRefsList().stream().allMatch(reference -> reference.getRefsList().stream().anyMatch(innerRef -> ((PdfDictionary)innerRef.getPdfObject()).equals(noteStructElem.getPdfObject())))) {
                throw new PdfUAConformanceException("Real content that refers to footnotes or endnotes shall use the Ref entry on the referring structure element to reference the FENote.");
            }
            if (noteStructElem.getAttributesList().stream().map(attribute -> attribute.getAttributeAsEnum(PdfName.NoteType.getValue())).anyMatch(noteTypeValue -> noteTypeValue != null && !PdfName.Footnote.getValue().equals(noteTypeValue) && !PdfName.Endnote.getValue().equals(noteTypeValue) && !PdfName.None.getValue().equals(noteTypeValue))) {
                throw new PdfUAConformanceException("The value of the NoteType attribute shall be either \"Footnote\", \"Endnote\" or \"None\".");
            }
        }
    }

    public static class PdfUA2NotesHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2NotesChecker checker;

        public PdfUA2NotesHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA2NotesChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

