/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA2HeadingsChecker {
    private final PdfUAValidationContext context;

    public PdfUA2HeadingsChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkLayoutElement(IRenderer renderer) {
        IAccessibleElement accessibleElement;
        String role;
        IPropertyContainer element = renderer.getModelElement();
        if (element instanceof IAccessibleElement && "H".equals(role = this.context.resolveToStandardRole((accessibleElement = (IAccessibleElement)((Object)element)).getAccessibilityProperties().getRole()))) {
            throw new PdfUAConformanceException("Document uses H tag: conforming files shall use the explicitly numbered heading structure types (H1-Hn) and shall not use the H structure type.");
        }
    }

    public void checkStructElement(IStructureNode structNode) {
        String role = this.context.resolveToStandardRole(structNode);
        if (role == null) {
            return;
        }
        if ("H".equals(role)) {
            throw new PdfUAConformanceException("Document uses H tag: conforming files shall use the explicitly numbered heading structure types (H1-Hn) and shall not use the H structure type.");
        }
    }

    public static class PdfUA2HeadingHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2HeadingsChecker checker;

        public PdfUA2HeadingHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA2HeadingsChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

