/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA2FormulaChecker {
    private static final String MATH = "math";
    private final PdfUAValidationContext context;

    private PdfUA2FormulaChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkStructElement(IStructureNode elem) {
        IStructureNode parent;
        PdfStructElem mathStructElem;
        String role = this.context.resolveToStandardRole(elem);
        if (role == null) {
            return;
        }
        if (MATH.equals(role) && (mathStructElem = this.context.getElementIfRoleMatches(new PdfName(MATH), elem)) != null && (parent = mathStructElem.getParent()) != null && !"Formula".equals(this.context.resolveToStandardRole(parent))) {
            throw new PdfUAConformanceException("The math structure type shall occur only as a child of a Formula structure element.");
        }
    }

    public static class PdfUA2FormulaTagHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2FormulaChecker checker;

        public PdfUA2FormulaTagHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA2FormulaChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

