/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.utils.checkers.PdfCheckersUtil;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2AnnotationChecker;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.List;

public final class PdfUA2FormChecker {
    private final PdfUAValidationContext context;

    public PdfUA2FormChecker(PdfUAValidationContext validationContext) {
        this.context = validationContext;
    }

    public void checkWidgetAnnotations(PdfDocument document) {
        int amountOfPages = document.getNumberOfPages();
        for (int i = 1; i <= amountOfPages; ++i) {
            PdfPage page = document.getPage(i);
            for (PdfAnnotation annot : page.getAnnotations()) {
                this.checkWidget((PdfDictionary)annot.getPdfObject());
            }
        }
    }

    public void checkFormFields(PdfDictionary form) {
        if (form == null) {
            return;
        }
        PdfArray fields = form.getAsArray(PdfName.Fields);
        if (fields == null) {
            return;
        }
        fields = PdfCheckersUtil.getFormFields(fields);
        for (PdfObject field : fields) {
            PdfDictionary fieldDic = (PdfDictionary)field;
            this.checkWidget(fieldDic);
            PdfUA2FormChecker.checkTextField(fieldDic);
        }
    }

    public void checkFormStructElement(IStructureNode elem) {
        if (PdfUA2FormChecker.isWidget(elem)) {
            Rectangle rectangle;
            PdfDictionary widget;
            PdfArray rect;
            String role = this.context.resolveToStandardRole(elem.getParent());
            if (!"Artifact".equals(role) && !"Form".equals(role)) {
                throw new PdfUAConformanceException("Widget annotation shall be either Form structure element or an Artifact.");
            }
            if ("Form".equals(role) && (rect = (widget = ((PdfObjRef)elem).getReferencedObject()).getAsArray(PdfName.Rect)) != null && rect.size() == 4 && (rectangle = rect.toRectangle()).getWidth() == 0.0f && rectangle.getHeight() == 0.0f) {
                throw new PdfUAConformanceException("Widget annotation of zero height and width shall be an artifact.");
            }
            return;
        }
        PdfStructElem form = this.context.getElementIfRoleMatches(PdfName.Form, elem);
        if (form == null) {
            return;
        }
        PdfUA2FormChecker.checkWidgetKids(form);
    }

    private static void checkWidgetKids(IStructureNode form) {
        List<IStructureNode> kids = form.getKids();
        boolean widgetFound = false;
        for (IStructureNode node : kids) {
            if (!PdfUA2FormChecker.isWidget(node)) continue;
            if (widgetFound) {
                throw new PdfUAConformanceException("Form structure element shall contain at most one widget annotation.");
            }
            widgetFound = true;
        }
    }

    private static boolean isWidget(IStructureNode node) {
        return node instanceof PdfObjRef && PdfFormAnnotationUtil.isPureWidgetOrMergedField(((PdfObjRef)node).getReferencedObject());
    }

    private static PdfObject getValueFromParent(PdfDictionary field) {
        PdfDictionary parent = field.getAsDictionary(PdfName.Parent);
        PdfObject fieldValue = field.get(PdfName.V);
        if (parent != null && (fieldValue = parent.get(PdfName.V)) == null) {
            fieldValue = PdfUA2FormChecker.getValueFromParent(parent);
        }
        return fieldValue;
    }

    private static void checkTextField(PdfDictionary fieldDic) {
        if (PdfName.Tx.equals(PdfFormField.getFormType(fieldDic)) && fieldDic.containsKey(PdfName.RV)) {
            String value;
            String richText = PdfUA2AnnotationChecker.getRichTextStringValue(fieldDic.get(PdfName.RV));
            if (richText.isEmpty()) {
                return;
            }
            PdfObject fieldValue = fieldDic.get(PdfName.V);
            if (fieldValue == null) {
                fieldValue = PdfUA2FormChecker.getValueFromParent(fieldDic);
            }
            if (!richText.equals(value = PdfFormField.getStringValue(fieldValue))) {
                throw new PdfUAConformanceException("For text fields, when RV entry is present, a V entry shall also be present, and they shall be textually equivalent.");
            }
        }
    }

    private void checkWidget(PdfDictionary fieldDic) {
        String role;
        if (!PdfFormAnnotationUtil.isPureWidgetOrMergedField(fieldDic)) {
            return;
        }
        PdfMcr objRef = null;
        if (fieldDic.getAsNumber(PdfName.StructParent) != null) {
            int i = fieldDic.getAsNumber(PdfName.StructParent).intValue();
            PdfDictionary pageDict = fieldDic.getAsDictionary(PdfName.P);
            objRef = this.context.findObjRefByStructParentIndex(i, pageDict);
        }
        if (objRef != null && !"Artifact".equals(role = this.context.resolveToStandardRole(objRef.getParent())) && !"Form".equals(role)) {
            throw new PdfUAConformanceException("Widget annotation shall be either Form structure element or an Artifact.");
        }
        if (!(objRef != null && this.isWidgetLabelPresent(objRef) || fieldDic.containsKey(PdfName.Contents))) {
            throw new PdfUAConformanceException("If label for a widget annotation is not present, Contents entry shall be provided.\nFor PdfFormAnnotation use PdfFormAnnotation#setAlternativeDescription(\"Your contents description\");\nfor PdfAnnotation use PdfAnnotation#setContents(\"Your contents description\");\nfor the layout engine use Element#getAccesibilityProperties().setAlternateDescription or FormField#setAlternativeDescription(\"Your contents description\").");
        }
        if (fieldDic.containsKey(PdfName.AA) && !fieldDic.containsKey(PdfName.Contents)) {
            throw new PdfUAConformanceException("If an additional action (AA) entry is present in a widget annotation, Contents entry shall describe the action's intent.\nFor PdfFormAnnotation use PdfFormAnnotation#setAlternativeDescription(\"Your contents description\");\nfor PdfAnnotation use PdfAnnotation#setContents(\"Your contents description\");\nfor the layout engine use Element#getAccesibilityProperties().setAlternateDescription or FormField#setAlternativeDescription(\"Your contents description\").");
        }
    }

    private boolean isWidgetLabelPresent(IStructureNode widget) {
        PdfStructElem form = this.context.getElementIfRoleMatches(PdfName.Form, widget.getParent());
        if (form == null) {
            return false;
        }
        List<IStructureNode> kids = form.getKids();
        for (IStructureNode node : kids) {
            if (!"Lbl".equals(this.context.resolveToStandardRole(node))) continue;
            return true;
        }
        return false;
    }

    public static class PdfUA2FormTagHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2FormChecker pdfUA2FormChecker;

        public PdfUA2FormTagHandler(PdfUAValidationContext context) {
            super(context);
            this.pdfUA2FormChecker = new PdfUA2FormChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.pdfUA2FormChecker.checkFormStructElement(elem);
        }
    }
}

