/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.validation.context.CanvasTextAdditionContext;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2StringChecker;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.ArrayList;
import java.util.List;

public class PdfUA2CanvasTextChecker {
    private final List<CanvasTextAdditionContext> textWithPua = new ArrayList<CanvasTextAdditionContext>();

    public void collectTextAdditionContext(CanvasTextAdditionContext context) {
        String text = context.getText();
        PdfDictionary attributes = context.getAttributes();
        PdfString alt = null;
        PdfString actualText = null;
        if (attributes != null) {
            alt = attributes.getAsString(PdfName.Alt);
            actualText = attributes.getAsString(PdfName.ActualText);
        }
        if (PdfUA2StringChecker.stringContainsPua(text) && alt == null && actualText == null) {
            this.textWithPua.add(context);
        }
    }

    public void checkCollectedContexts(PdfDocument document) {
        for (CanvasTextAdditionContext context : this.textWithPua) {
            if (context.getMcId() == null) {
                throw new PdfUAConformanceException("In all cases, where real content maps to Unicode PUA values, an ActualText or Alt entry shall be present.");
            }
            PdfMcr mcr = PdfUA2CanvasTextChecker.findMcrByMcId(document, context.getMcId(), context.getContentStream());
            if (mcr == null) {
                throw new PdfUAConformanceException("In all cases, where real content maps to Unicode PUA values, an ActualText or Alt entry shall be present.");
            }
            IStructureNode structureNode = mcr.getParent();
            if (!(structureNode instanceof PdfStructElem)) {
                throw new PdfUAConformanceException("In all cases, where real content maps to Unicode PUA values, an ActualText or Alt entry shall be present.");
            }
            PdfStructElem structElem = (PdfStructElem)structureNode;
            PdfString alt = structElem.getAlt();
            PdfString actualText = structElem.getActualText();
            if (alt != null || actualText != null) continue;
            throw new PdfUAConformanceException("In all cases, where real content maps to Unicode PUA values, an ActualText or Alt entry shall be present.");
        }
    }

    private static PdfMcr findMcrByMcId(PdfDocument document, PdfNumber mcId, PdfStream contentStream) {
        for (int i = 1; i <= document.getNumberOfPages(); ++i) {
            PdfPage page = document.getPage(i);
            for (int j = 0; j < page.getContentStreamCount(); ++j) {
                PdfMcr mcr;
                PdfStream pageStream = page.getContentStream(j);
                if (!pageStream.getIndirectReference().equals(contentStream.getIndirectReference()) || (mcr = document.getStructTreeRoot().findMcrByMcid((PdfDictionary)page.getPdfObject(), mcId.intValue())) == null) continue;
                return mcr;
            }
        }
        return null;
    }
}

