/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.util.XmlUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.utils.checkers.PdfCheckersUtil;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PdfUA2AnnotationChecker {
    private static final Set<PdfName> markupAnnotationTypes = new HashSet<PdfName>(Arrays.asList(PdfName.Text, PdfName.FreeText, PdfName.Line, PdfName.Square, PdfName.Circle, PdfName.Polygon, PdfName.PolyLine, PdfName.Highlight, PdfName.Underline, PdfName.Squiggly, PdfName.StrikeOut, PdfName.Caret, PdfName.Stamp, PdfName.Ink, PdfName.FileAttachment, PdfName.Redaction, PdfName.Projection));

    private PdfUA2AnnotationChecker() {
    }

    public static void checkAnnotations(PdfDocument pdfDocument) {
        int amountOfPages = pdfDocument.getNumberOfPages();
        for (int i = 1; i <= amountOfPages; ++i) {
            PdfName tabs;
            PdfPage page = pdfDocument.getPage(i);
            List<PdfAnnotation> annotations = page.getAnnotations();
            if (!(annotations.isEmpty() || PdfName.A.equals(tabs = page.getTabOrder()) || PdfName.W.equals(tabs) || PdfName.S.equals(tabs))) {
                throw new PdfUAConformanceException("Page that includes an annotation shall contain a Tabs entry in its page dictionary, and its value shall be A, W or S.");
            }
            for (PdfAnnotation annot : annotations) {
                if (((PdfDictionary)annot.getPdfObject()).containsKey(PdfName.StructParent)) continue;
                PdfUA2AnnotationChecker.checkAnnotation((PdfDictionary)annot.getPdfObject(), (PdfStructElem)null);
            }
        }
    }

    public static void checkAnnotation(PdfDictionary annotation, PdfUAValidationContext context) {
        PdfDictionary pageDict;
        int structParentIndex;
        PdfObjRef objRef;
        PdfStructElem parent = null;
        if (annotation.getAsNumber(PdfName.StructParent) != null && (objRef = context.findObjRefByStructParentIndex(structParentIndex = annotation.getAsNumber(PdfName.StructParent).intValue(), pageDict = annotation.getAsDictionary(PdfName.P))) != null) {
            parent = (PdfStructElem)objRef.getParent();
        }
        PdfUA2AnnotationChecker.checkAnnotation(annotation, parent);
    }

    static void checkAnnotation(PdfDictionary annotation, PdfStructElem parent) {
        PdfDictionary fileSpec;
        PdfString contents;
        PdfName subtype;
        PdfName parentRole;
        if (parent != null) {
            PdfString alt = parent.getAlt();
            PdfString contents2 = annotation.getAsString(PdfName.Contents);
            if (alt != null && contents2 != null && !alt.getValue().equals(contents2.getValue())) {
                throw new PdfUAConformanceException("If annotation has Contents entry and enclosing structure element has Alt entry, the values shall be identical.");
            }
        }
        PdfName pdfName = parentRole = parent == null ? PdfName.Artifact : parent.getRole();
        if (!PdfName.Artifact.equals(parentRole)) {
            PdfUA2AnnotationChecker.checkAnnotationFlags(annotation);
        }
        if (PdfName.Widget.equals(subtype = annotation.getAsName(PdfName.Subtype))) {
            return;
        }
        if (markupAnnotationTypes.contains(subtype)) {
            PdfUA2AnnotationChecker.checkMarkupAnnotations(annotation, parentRole);
        }
        if (PdfName.Stamp.equals(subtype)) {
            PdfName name = annotation.getAsName(PdfName.Name);
            PdfObject contents3 = annotation.get(PdfName.Contents);
            if (name == null && contents3 == null) {
                throw new PdfUAConformanceException("Stamp annotation shall contain either Name or Contents entry in order to describe the author\u2019s intent.");
            }
        }
        if ((PdfName.Ink.equals(subtype) || PdfName.Screen.equals(subtype) || PdfName._3D.equals(subtype) || PdfName.RichMedia.equals(subtype)) && ((contents = annotation.getAsString(PdfName.Contents)) == null || contents.getValue().isEmpty())) {
            throw new PdfUAConformanceException("Annotation shall specify an alternate description or author's intent via its Contents key.");
        }
        if (PdfName.Popup.equals(subtype) && parent != null) {
            throw new PdfUAConformanceException("Popup annotations shall not be present in the tag structure tree.");
        }
        if (PdfName.FileAttachment.equals(subtype) && (fileSpec = annotation.getAsDictionary(PdfName.FS)) != null && !fileSpec.containsKey(PdfName.AFRelationship)) {
            throw new PdfUAConformanceException("When a file attachment annotation references file specification dictionary, that file specification dictionary shall include an AFRelationship entry.");
        }
        if (PdfName.Sound.equals(subtype) || PdfName.Movie.equals(subtype) || PdfName.TrapNet.equals(subtype)) {
            throw new PdfUAConformanceException(MessageFormatUtil.format("{0} annotations are deprecated in PDF 2.0 and therefore shall not be present.", subtype.getValue()));
        }
        if (PdfName.PrinterMark.equals(subtype) && !PdfName.Artifact.equals(parentRole)) {
            throw new PdfUAConformanceException("PrinterMark annotation shall be an artifact.");
        }
        if (PdfName.Watermark.equals(subtype) && !PdfName.Artifact.equals(parentRole)) {
            PdfUA2AnnotationChecker.checkMarkupAnnotations(annotation, parentRole);
        }
    }

    private static void checkMarkupAnnotations(PdfDictionary annotation, PdfName parentRole) {
        if (!PdfName.Annot.equals(parentRole)) {
            throw new PdfUAConformanceException("Markup annotation shall be enclosed by Annot tag in the tag tree structure.");
        }
        PdfString contents = annotation.getAsString(PdfName.Contents);
        if (contents == null) {
            return;
        }
        String rc = PdfUA2AnnotationChecker.getRichTextStringValue(annotation.get(PdfName.RC));
        if (!rc.isEmpty() && !rc.equals(contents.getValue())) {
            throw new PdfUAConformanceException("If markup annotation contains both RC and Contents entries, they shall be textually equivalent.");
        }
    }

    static String getRichTextStringValue(PdfObject rv) {
        String richText = PdfFormField.getStringValue(rv);
        if (richText.isEmpty()) {
            return richText;
        }
        try {
            return PdfUA2AnnotationChecker.parseRichText(XmlUtil.initXmlDocument(new ByteArrayInputStream(richText.getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage(), e);
        }
    }

    private static String parseRichText(Node node) {
        StringBuilder richText = new StringBuilder();
        NodeList allChildren = node.getChildNodes();
        for (int k = 0; k < allChildren.getLength(); ++k) {
            Node child = allChildren.item(k);
            richText.append(child.getNodeValue() == null ? PdfUA2AnnotationChecker.parseRichText(child) : child.getNodeValue());
        }
        return richText.toString();
    }

    private static void checkAnnotationFlags(PdfDictionary annotation) {
        PdfNumber f = annotation.getAsNumber(PdfName.F);
        if (f == null) {
            return;
        }
        int flags = f.intValue();
        if (PdfCheckersUtil.checkFlag(flags, 1)) {
            throw new PdfUAConformanceException("Annotations with the Invisible flag set shall be artifacts.");
        }
        if (PdfCheckersUtil.checkFlag(flags, 32) && !PdfCheckersUtil.checkFlag(flags, 256)) {
            throw new PdfUAConformanceException("Annotations with the NoView flag set and the ToggleNoView flag not set shall be artifacts.");
        }
    }

    public static class PdfUA2AnnotationHandler
    extends ContextAwareTagTreeIteratorHandler {
        public PdfUA2AnnotationHandler(PdfUAValidationContext context) {
            super(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            if (!(elem instanceof PdfObjRef)) {
                return;
            }
            PdfDictionary annotObj = ((PdfObjRef)elem).getReferencedObject();
            if (annotObj == null || !annotObj.containsKey(PdfName.Subtype)) {
                return;
            }
            PdfStructElem parent = (PdfStructElem)elem.getParent();
            PdfUA2AnnotationChecker.checkAnnotation(annotObj, parent);
        }
    }
}

