/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua1;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA1ListChecker {
    private final PdfUAValidationContext context;

    public PdfUA1ListChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkStructElement(IStructureNode structNode) {
        PdfStructElem list = this.context.getElementIfRoleMatches(PdfName.L, structNode);
        if (list == null) {
            return;
        }
        for (IStructureNode listItem : list.getKids()) {
            String listItemRole = this.context.resolveToStandardRole(listItem);
            if (!"LI".equals(listItemRole)) continue;
            for (IStructureNode kid : listItem.getKids()) {
                String kidRole = this.context.resolveToStandardRole(kid);
                if ("Lbl".equals(kidRole) || "LBody".equals(kidRole) || "Artifact".equals(kidRole)) continue;
                throw new PdfUAConformanceException("Any real content within an LI structure element that is not enclosed in a Lbl structure element shall be enclosed in an LBody structure element.");
            }
        }
    }

    public static class PdfUA1ListHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA1ListChecker checker;

        public PdfUA1ListHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA1ListChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

