/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public class ActionCheckUtil {
    private ActionCheckUtil() {
    }

    public static void checkAction(PdfDictionary action) {
        if (action == null) {
            return;
        }
        PdfName s = action.getAsName(PdfName.S);
        PdfDictionary rendition = action.getAsDictionary(PdfName.R);
        if (PdfName.Rendition.equals(s) && rendition != null) {
            ActionCheckUtil.checkRenditionMedia(rendition.getAsDictionary(PdfName.BE) != null ? rendition.getAsDictionary(PdfName.BE).getAsDictionary(PdfName.C) : null);
            ActionCheckUtil.checkRenditionMedia(rendition.getAsDictionary(PdfName.MH) != null ? rendition.getAsDictionary(PdfName.MH).getAsDictionary(PdfName.C) : null);
            ActionCheckUtil.checkRenditionMedia(rendition.getAsDictionary(PdfName.C));
        }
    }

    private static void checkRenditionMedia(PdfDictionary mediaClipDict) {
        if (mediaClipDict != null && (mediaClipDict.get(PdfName.CT) == null || mediaClipDict.get(PdfName.Alt) == null)) {
            throw new PdfUAConformanceException("CT or Alt entry is missing from the media clip data dictionary.");
        }
    }
}

