/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.utils.checkers.FontCheckUtil;
import com.itextpdf.kernel.utils.checkers.PdfCheckersUtil;
import com.itextpdf.kernel.validation.IValidationChecker;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public abstract class PdfUAChecker
implements IValidationChecker {
    static final Function<String, PdfException> EXCEPTION_SUPPLIER = msg -> new PdfUAConformanceException((String)msg);
    private boolean warnedOnPageFlush = false;

    protected PdfUAChecker() {
    }

    public void warnOnPageFlush() {
        if (!this.warnedOnPageFlush) {
            LoggerFactory.getLogger(PdfUAChecker.class).warn("Page flushing is disabled in PDF/UA mode to allow UA checks to be applied. Page will only be flushed on closing.");
            this.warnedOnPageFlush = true;
        }
    }

    void checkLang(PdfCatalog catalog) {
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        PdfObject lang = catalogDict.get(PdfName.Lang);
        if (!(lang instanceof PdfString)) {
            throw new PdfUAConformanceException("Catalog dictionary should contain lang entry.");
        }
        if (((PdfString)lang).getValue().isEmpty()) {
            throw new PdfUAConformanceException("Document does not contain valid lang entry.");
        }
    }

    void checkViewerPreferences(PdfCatalog catalog) {
        PdfDictionary viewerPreferences = ((PdfDictionary)catalog.getPdfObject()).getAsDictionary(PdfName.ViewerPreferences);
        if (viewerPreferences == null) {
            throw new PdfUAConformanceException("ViewerPreferences dictionary of the Catalog dictionary does not contain a DisplayDocTitle entry.");
        }
        PdfObject displayDocTitle = viewerPreferences.get(PdfName.DisplayDocTitle);
        if (!(displayDocTitle instanceof PdfBoolean)) {
            throw new PdfUAConformanceException("ViewerPreferences dictionary of the Catalog dictionary does not contain a DisplayDocTitle entry.");
        }
        if (PdfBoolean.FALSE.equals(displayDocTitle)) {
            throw new PdfUAConformanceException("ViewerPreferences dictionary of the Catalog dictionary contains a DisplayDocTitle entry with a value of false.");
        }
    }

    void checkOCProperties(PdfDictionary ocProperties) {
        if (ocProperties == null) {
            return;
        }
        PdfArray configs = ocProperties.getAsArray(PdfName.Configs);
        if (configs != null && !configs.isEmpty()) {
            PdfDictionary d = ocProperties.getAsDictionary(PdfName.D);
            PdfUAChecker.checkOCGNameAndASKey(d);
            for (PdfObject config : configs) {
                PdfUAChecker.checkOCGNameAndASKey((PdfDictionary)config);
            }
            PdfArray ocgsArray = ocProperties.getAsArray(PdfName.OCGs);
            if (ocgsArray != null) {
                for (PdfObject ocg : ocgsArray) {
                    PdfUAChecker.checkOCGNameAndASKey((PdfDictionary)ocg);
                }
            }
        }
    }

    void checkLogicalStructureInBMC(Stack<Tuple2<PdfName, PdfDictionary>> stack, Tuple2<PdfName, PdfDictionary> currentBmc, PdfDocument document) {
        if (stack.isEmpty()) {
            return;
        }
        boolean isRealContent = PdfUAChecker.isRealContent(currentBmc, document);
        boolean isArtifact = PdfName.Artifact.equals(currentBmc.getFirst());
        if (isArtifact && PdfUAChecker.isInsideRealContent(stack, document)) {
            throw new PdfUAConformanceException("Content marked as artifact may only reside in Artifact content.");
        }
        if (isRealContent && PdfUAChecker.isInsideArtifact(stack)) {
            throw new PdfUAConformanceException("Content marked as content may not reside in Artifact content.");
        }
    }

    void checkContentInCanvas(Stack<Tuple2<PdfName, PdfDictionary>> tagStack, PdfDocument document) {
        if (tagStack.isEmpty()) {
            throw new PdfUAConformanceException("Tag hasn't been added before adding content to the canvas.");
        }
        boolean insideRealContent = PdfUAChecker.isInsideRealContent(tagStack, document);
        boolean insideArtifact = PdfUAChecker.isInsideArtifact(tagStack);
        if (insideRealContent && insideArtifact) {
            throw new PdfUAConformanceException("Tagged content is present inside content marked as Artifact or vice versa.");
        }
        if (!insideRealContent && !insideArtifact) {
            throw new PdfUAConformanceException("Content is neither marked as Artifact nor tagged as real content.");
        }
    }

    void checkFonts(Collection<PdfFont> fontsInDocument) {
        HashSet<String> fontNamesThatAreNotEmbedded = new HashSet<String>();
        for (PdfFont font : fontsInDocument) {
            boolean symbolic;
            if (!font.isEmbedded()) {
                fontNamesThatAreNotEmbedded.add(font.getFontProgram().getFontNames().getFontName());
                continue;
            }
            if (!(font instanceof PdfTrueTypeFont)) continue;
            PdfTrueTypeFont trueTypeFont = (PdfTrueTypeFont)font;
            int flags = trueTypeFont.getFontProgram().getPdfFontFlags();
            boolean bl = symbolic = PdfCheckersUtil.checkFlag(flags, 4) && !PdfCheckersUtil.checkFlag(flags, 32);
            if (symbolic) {
                this.checkSymbolicTrueTypeFont(trueTypeFont);
                continue;
            }
            this.checkNonSymbolicTrueTypeFont(trueTypeFont);
        }
        if (!fontNamesThatAreNotEmbedded.isEmpty()) {
            throw new PdfUAConformanceException(MessageFormatUtil.format("Following font(s) are not embedded: {0}", String.join((CharSequence)", ", fontNamesThatAreNotEmbedded)));
        }
    }

    abstract void checkNonSymbolicCmapSubtable(TrueTypeFont var1);

    abstract void checkSymbolicCmapSubtable(TrueTypeFont var1);

    void checkText(String str, PdfFont font) {
        int index = FontCheckUtil.checkGlyphsOfText(str, font, new UaCharacterChecker());
        if (index != -1) {
            throw new PdfUAConformanceException(MessageFormatUtil.format("The '{0}' glyph either isn't defined in embedded font or doesn't have unicode mapping.", Character.valueOf(str.charAt(index))));
        }
    }

    private static void checkOCGNameAndASKey(PdfDictionary dict) {
        if (dict == null) {
            return;
        }
        if (dict.get(PdfName.AS) != null) {
            throw new PdfUAConformanceException("An AS entry appears in an Optional Content.");
        }
        if (!(dict.get(PdfName.Name) instanceof PdfString) || ((PdfString)dict.get(PdfName.Name)).toString().isEmpty()) {
            throw new PdfUAConformanceException("Name entry is missing or has an empty string as its value in an Optional Content Configuration Dictionary.");
        }
    }

    private static boolean isInsideArtifact(Stack<Tuple2<PdfName, PdfDictionary>> tagStack) {
        for (Tuple2 tuple2 : tagStack) {
            if (!PdfName.Artifact.equals(tuple2.getFirst())) continue;
            return true;
        }
        return false;
    }

    private static boolean isInsideRealContent(Stack<Tuple2<PdfName, PdfDictionary>> tagStack, PdfDocument document) {
        for (Tuple2 tuple2 : tagStack) {
            if (!PdfUAChecker.isRealContent(tuple2, document)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRealContent(Tuple2<PdfName, PdfDictionary> tag, PdfDocument document) {
        if (PdfName.Artifact.equals(tag.getFirst())) {
            return false;
        }
        PdfDictionary properties = tag.getSecond();
        if (properties == null || !properties.containsKey(PdfName.MCID)) {
            return false;
        }
        PdfMcr mcr = PdfUAChecker.mcrExists(document, properties.getAsInt(PdfName.MCID));
        if (mcr == null) {
            throw new PdfUAConformanceException("Content with MCID, but MCID wasn't found in StructTreeRoot.");
        }
        return true;
    }

    private static PdfMcr mcrExists(PdfDocument document, int mcid) {
        int amountOfPages = document.getNumberOfPages();
        for (int i = 1; i <= amountOfPages; ++i) {
            PdfPage page = document.getPage(i);
            PdfMcr mcr = document.getStructTreeRoot().findMcrByMcid((PdfDictionary)page.getPdfObject(), mcid);
            if (mcr == null) continue;
            return mcr;
        }
        return null;
    }

    private void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        TrueTypeFont fontProgram = (TrueTypeFont)trueTypeFont.getFontProgram();
        this.checkNonSymbolicCmapSubtable(fontProgram);
        String encoding = trueTypeFont.getFontEncoding().getBaseEncoding();
        if (!"Cp1252".equals(encoding) && !"MacRoman".equals(encoding)) {
            throw new PdfUAConformanceException("All non-symbolic TrueType fonts shall have either MacRomanEncoding or WinAnsiEncoding as the value for the Encoding key in the Font dictionary, or as the value for the BaseEncoding key in the dictionary that is the value of the Encoding key in the Font dictionary");
        }
        if (trueTypeFont.getFontEncoding().hasDifferences() && !fontProgram.isCmapPresent(3, 1)) {
            throw new PdfUAConformanceException("All non-symbolic TrueType fonts shall not define a Differences array unless all the glyph names in the Differences array are listed in the Adobe Glyph List and the embedded font program contains at least the Microsoft Unicode (3, 1 \u2013 Platform ID = 3, Encoding ID = 1) encoding in the \u201ccmap\u201d subtable.");
        }
    }

    private void checkSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        if (((PdfDictionary)trueTypeFont.getPdfObject()).containsKey(PdfName.Encoding)) {
            throw new PdfUAConformanceException("Symbolic TrueType fonts shall not contain an Encoding entry in the font dictionary.");
        }
        TrueTypeFont fontProgram = (TrueTypeFont)trueTypeFont.getFontProgram();
        this.checkSymbolicCmapSubtable(fontProgram);
    }

    private static final class UaCharacterChecker
    implements FontCheckUtil.CharacterChecker {
        @Override
        public boolean check(int ch, PdfFont font) {
            if (font.containsGlyph(ch)) {
                return !font.getGlyph(ch).hasValidUnicode();
            }
            return true;
        }
    }
}

