/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.utils.checkers.PdfCheckersUtil;
import com.itextpdf.kernel.validation.IValidationContext;
import com.itextpdf.kernel.validation.context.CanvasBmcValidationContext;
import com.itextpdf.kernel.validation.context.CanvasTextAdditionContext;
import com.itextpdf.kernel.validation.context.CanvasWritingContentValidationContext;
import com.itextpdf.kernel.validation.context.FontValidationContext;
import com.itextpdf.kernel.validation.context.PdfAnnotationContext;
import com.itextpdf.kernel.validation.context.PdfDestinationAdditionContext;
import com.itextpdf.kernel.validation.context.PdfDocumentValidationContext;
import com.itextpdf.kernel.validation.context.PdfObjectValidationContext;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.layout.validation.context.LayoutValidationContext;
import com.itextpdf.pdfua.checkers.PdfUAChecker;
import com.itextpdf.pdfua.checkers.utils.GraphicsCheckUtil;
import com.itextpdf.pdfua.checkers.utils.LayoutCheckUtil;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.TableCheckUtil;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2AnnotationChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2CanvasTextChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2DestinationsChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2EmbeddedFilesChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2FormChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2FormulaChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2HeadingsChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2LinkChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2ListChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2NotesChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2StringChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2TableOfContentsChecker;
import com.itextpdf.pdfua.checkers.utils.ua2.PdfUA2XfaChecker;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUA2Checker
extends PdfUAChecker {
    private final PdfDocument pdfDocument;
    private final PdfUAValidationContext context;
    private final PdfUA2CanvasTextChecker textChecker = new PdfUA2CanvasTextChecker();

    public PdfUA2Checker(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.context = new PdfUAValidationContext(this.pdfDocument);
    }

    @Override
    public void validate(IValidationContext context) {
        switch (context.getType()) {
            case PDF_DOCUMENT: {
                PdfDocumentValidationContext pdfDocContext = (PdfDocumentValidationContext)context;
                this.checkCatalog(pdfDocContext.getPdfDocument().getCatalog());
                this.checkStructureTreeRoot(pdfDocContext.getPdfDocument().getStructTreeRoot());
                this.checkFonts(pdfDocContext.getDocumentFonts());
                new PdfUA2DestinationsChecker(pdfDocContext.getPdfDocument()).checkDestinations();
                PdfUA2XfaChecker.check(pdfDocContext.getPdfDocument());
                this.textChecker.checkCollectedContexts(pdfDocContext.getPdfDocument());
                break;
            }
            case FONT: {
                FontValidationContext fontContext = (FontValidationContext)context;
                this.checkText(fontContext.getText(), fontContext.getFont());
                break;
            }
            case CANVAS_BEGIN_MARKED_CONTENT: {
                CanvasBmcValidationContext bmcContext = (CanvasBmcValidationContext)context;
                this.checkLogicalStructureInBMC(bmcContext.getTagStructureStack(), bmcContext.getCurrentBmc(), this.pdfDocument);
                break;
            }
            case CANVAS_WRITING_CONTENT: {
                CanvasWritingContentValidationContext writingContext = (CanvasWritingContentValidationContext)context;
                this.checkContentInCanvas(writingContext.getTagStructureStack(), this.pdfDocument);
                break;
            }
            case LAYOUT: {
                LayoutValidationContext layoutContext = (LayoutValidationContext)context;
                new LayoutCheckUtil(this.context).checkRenderer(layoutContext.getRenderer());
                new PdfUA2HeadingsChecker(this.context).checkLayoutElement(layoutContext.getRenderer());
                break;
            }
            case DESTINATION_ADDITION: {
                PdfDestinationAdditionContext destinationAdditionContext = (PdfDestinationAdditionContext)context;
                new PdfUA2DestinationsChecker(destinationAdditionContext, this.pdfDocument).checkDestinationsOnCreation();
                break;
            }
            case PDF_OBJECT: {
                PdfObjectValidationContext validationContext = (PdfObjectValidationContext)context;
                this.checkPdfObject(validationContext.getObject());
                break;
            }
            case ANNOTATION: {
                PdfAnnotationContext annotationContext = (PdfAnnotationContext)context;
                PdfUA2AnnotationChecker.checkAnnotation(annotationContext.getAnnotation(), this.context);
                break;
            }
            case CANVAS_TEXT_ADDITION: {
                CanvasTextAdditionContext canvasTextAdditionContext = (CanvasTextAdditionContext)context;
                this.textChecker.collectTextAdditionContext(canvasTextAdditionContext);
            }
        }
    }

    @Override
    public boolean isPdfObjectReadyToFlush(PdfObject object) {
        return false;
    }

    protected void checkMetadata(PdfCatalog catalog) {
        PdfCheckersUtil.checkMetadata((PdfDictionary)catalog.getPdfObject(), PdfConformance.PDF_UA_2, EXCEPTION_SUPPLIER);
        try {
            XMPMeta metadata = catalog.getDocument().getXmpMetadata();
            if (metadata.getProperty("http://purl.org/dc/elements/1.1/", "title") == null) {
                throw new PdfUAConformanceException("Metadata shall contain dc:title entry.");
            }
        }
        catch (XMPException e) {
            throw new PdfUAConformanceException(e.getMessage());
        }
    }

    @Override
    void checkNonSymbolicCmapSubtable(TrueTypeFont fontProgram) {
        if (!fontProgram.isCmapPresent(3, 1) && !fontProgram.isCmapPresent(1, 0)) {
            throw new PdfUAConformanceException("For all non-symbolic TrueType fonts used for rendering, the embedded TrueType font program shall contain at least the Microsoft Unicode (3, 1 \u2013 Platform ID = 3, Encoding ID = 1), or the Macintosh Roman (1, 0 \u2013 Platform ID = 1, Encoding ID = 0) \u201ccmap\u201d subtable.");
        }
    }

    @Override
    void checkSymbolicCmapSubtable(TrueTypeFont fontProgram) {
        if (!fontProgram.isCmapPresent(3, 0) && !fontProgram.isCmapPresent(1, 0)) {
            throw new PdfUAConformanceException("For symbolic TrueType fonts the 'cmap' subtable in the embedded font program shall either contain the Microsoft Symbol (3,0 \u2013 Platform ID=3, Encoding ID=0) or the Mac Roman (1,0 \u2013 Platform ID=1, Encoding ID=0) encoding.");
        }
    }

    private void checkPdfObject(PdfObject obj) {
        switch (obj.getType()) {
            case 10: {
                PdfUA2StringChecker.checkPdfString((PdfString)obj);
                break;
            }
            case 1: {
                this.checkArrayRecursively((PdfArray)obj);
                break;
            }
            case 3: 
            case 9: {
                this.checkDictionaryRecursively((PdfDictionary)obj);
            }
        }
    }

    private void checkArrayRecursively(PdfArray array) {
        for (int i = 0; i < array.size(); ++i) {
            PdfObject object = array.get(i, false);
            if (object == null || object.isIndirect()) continue;
            this.checkPdfObject(object);
        }
    }

    private void checkDictionaryRecursively(PdfDictionary dictionary) {
        for (PdfName name : dictionary.keySet()) {
            PdfObject object = dictionary.get(name, false);
            if (object == null || object.isIndirect()) continue;
            this.checkPdfObject(object);
        }
    }

    private void checkCatalog(PdfCatalog catalog) {
        this.checkLang(catalog);
        this.checkMetadata(catalog);
        this.checkViewerPreferences(catalog);
        this.checkOCProperties(((PdfDictionary)catalog.getPdfObject()).getAsDictionary(PdfName.OCProperties));
        this.checkFormFieldsAndAnnotations(catalog);
        PdfUA2EmbeddedFilesChecker.checkEmbeddedFiles(catalog);
    }

    private void checkFormFieldsAndAnnotations(PdfCatalog catalog) {
        PdfUA2FormChecker formChecker = new PdfUA2FormChecker(this.context);
        formChecker.checkFormFields(((PdfDictionary)catalog.getPdfObject()).getAsDictionary(PdfName.AcroForm));
        formChecker.checkWidgetAnnotations(this.pdfDocument);
        PdfUA2LinkChecker.checkLinkAnnotations(this.pdfDocument);
        PdfUA2AnnotationChecker.checkAnnotations(this.pdfDocument);
    }

    private void checkStructureTreeRoot(PdfStructTreeRoot structTreeRoot) {
        List<PdfNamespace> namespaces = structTreeRoot.getNamespaces();
        for (PdfNamespace namespace : namespaces) {
            PdfDictionary roleMap = namespace.getNamespaceRoleMap();
            if (roleMap == null) continue;
            block1: for (Map.Entry<PdfName, PdfObject> entry : roleMap.entrySet()) {
                String role = entry.getKey().getValue();
                IRoleMappingResolver roleMappingResolver = this.pdfDocument.getTagStructureContext().getRoleMappingResolver(role, namespace);
                int i = 0;
                int maxIters = 100;
                while (roleMappingResolver.resolveNextMapping()) {
                    if (++i > maxIters) {
                        Logger logger = LoggerFactory.getLogger(PdfUA2Checker.class);
                        logger.error(MessageFormatUtil.format("Cannot resolve \"{0}\" role in {1} namespace mapping, because of the too much transitive mappings.", role, namespace));
                        continue block1;
                    }
                    PdfNamespace roleMapToNamespace = roleMappingResolver.getNamespace();
                    if (!namespace.getNamespaceName().equals(roleMapToNamespace.getNamespaceName())) continue;
                    throw new PdfUAConformanceException(MessageFormatUtil.format("Structure type {0}:{1} is role mapped to other structure type in the same namespace.", namespace.getNamespaceName(), role));
                }
            }
        }
        TagTreeIterator tagTreeIterator = new TagTreeIterator(structTreeRoot);
        tagTreeIterator.addHandler(new GraphicsCheckUtil.GraphicsHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2HeadingsChecker.PdfUA2HeadingHandler(this.context));
        tagTreeIterator.addHandler(new TableCheckUtil.TableHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2FormChecker.PdfUA2FormTagHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2AnnotationChecker.PdfUA2AnnotationHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2ListChecker.PdfUA2ListHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2NotesChecker.PdfUA2NotesHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2TableOfContentsChecker.PdfUA2TableOfContentsHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2FormulaChecker.PdfUA2FormulaTagHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA2LinkChecker.PdfUA2LinkAnnotationHandler(this.context, this.pdfDocument));
        tagTreeIterator.traverse();
    }
}

