/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.utils.checkers.PdfCheckersUtil;
import com.itextpdf.kernel.validation.IValidationContext;
import com.itextpdf.kernel.validation.context.CanvasBmcValidationContext;
import com.itextpdf.kernel.validation.context.CanvasWritingContentValidationContext;
import com.itextpdf.kernel.validation.context.CryptoValidationContext;
import com.itextpdf.kernel.validation.context.DuplicateIdEntryValidationContext;
import com.itextpdf.kernel.validation.context.FontValidationContext;
import com.itextpdf.kernel.validation.context.PdfDocumentValidationContext;
import com.itextpdf.kernel.validation.context.PdfObjectValidationContext;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.layout.validation.context.LayoutValidationContext;
import com.itextpdf.pdfua.checkers.PdfUAChecker;
import com.itextpdf.pdfua.checkers.utils.GraphicsCheckUtil;
import com.itextpdf.pdfua.checkers.utils.LayoutCheckUtil;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.TableCheckUtil;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1AnnotationChecker;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1FormChecker;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1FormulaChecker;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1HeadingsChecker;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1ListChecker;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1NotesChecker;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1XfaCheckUtil;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.Map;
import java.util.Stack;

public class PdfUA1Checker
extends PdfUAChecker {
    private final PdfDocument pdfDocument;
    private final TagStructureContext tagStructureContext;
    private final PdfUA1HeadingsChecker headingsChecker;
    private final PdfUAValidationContext context;

    public PdfUA1Checker(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.tagStructureContext = new TagStructureContext(pdfDocument);
        this.context = new PdfUAValidationContext(pdfDocument);
        this.headingsChecker = new PdfUA1HeadingsChecker(this.context);
    }

    @Override
    public void validate(IValidationContext context) {
        switch (context.getType()) {
            case PDF_DOCUMENT: {
                PdfDocumentValidationContext pdfDocContext = (PdfDocumentValidationContext)context;
                this.checkCatalog(pdfDocContext.getPdfDocument().getCatalog());
                this.checkStructureTreeRoot(pdfDocContext.getPdfDocument().getStructTreeRoot());
                this.checkFonts(pdfDocContext.getDocumentFonts());
                PdfUA1XfaCheckUtil.check(pdfDocContext.getPdfDocument());
                break;
            }
            case PDF_OBJECT: {
                PdfObjectValidationContext objContext = (PdfObjectValidationContext)context;
                this.checkPdfObject(objContext.getObject());
                break;
            }
            case CRYPTO: {
                CryptoValidationContext cryptoContext = (CryptoValidationContext)context;
                this.checkCrypto((PdfDictionary)cryptoContext.getCrypto());
                break;
            }
            case FONT: {
                FontValidationContext fontContext = (FontValidationContext)context;
                this.checkText(fontContext.getText(), fontContext.getFont());
                break;
            }
            case CANVAS_BEGIN_MARKED_CONTENT: {
                CanvasBmcValidationContext bmcContext = (CanvasBmcValidationContext)context;
                this.checkLogicalStructureInBMC(bmcContext.getTagStructureStack(), bmcContext.getCurrentBmc(), this.pdfDocument);
                break;
            }
            case CANVAS_WRITING_CONTENT: {
                CanvasWritingContentValidationContext writingContext = (CanvasWritingContentValidationContext)context;
                this.checkContentInCanvas(writingContext.getTagStructureStack(), this.pdfDocument);
                break;
            }
            case LAYOUT: {
                LayoutValidationContext layoutContext = (LayoutValidationContext)context;
                new LayoutCheckUtil(this.context).checkRenderer(layoutContext.getRenderer());
                this.headingsChecker.checkLayoutElement(layoutContext.getRenderer());
                break;
            }
            case DUPLICATE_ID_ENTRY: {
                DuplicateIdEntryValidationContext idContext = (DuplicateIdEntryValidationContext)context;
                throw new PdfUAConformanceException(MessageFormatUtil.format("ID entry '{0}' shall be unique among all elements in the document\u2019s structure hierarchy", idContext.getId()));
            }
        }
    }

    @Override
    public boolean isPdfObjectReadyToFlush(PdfObject object) {
        return false;
    }

    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (!(!fileSpec.containsKey(PdfName.EF) || fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF))) {
            throw new PdfUAConformanceException("File specification dictionary shall contain f key and uf key.");
        }
    }

    protected void checkMetadata(PdfCatalog catalog) {
        if (catalog.getDocument().getPdfVersion().compareTo(PdfVersion.PDF_1_7) > 0) {
            throw new PdfUAConformanceException("Specified document pdf version isn't supported in pdf/ua.");
        }
        try {
            XMPMeta metadata = catalog.getDocument().getXmpMetadata();
            if (metadata == null) {
                throw new PdfUAConformanceException("Document shall contain a XMP metadata stream.");
            }
            Integer part = metadata.getPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part");
            if (!Integer.valueOf(1).equals(part)) {
                throw new PdfUAConformanceException("Metadata shall contain correct pdfuaid:part version identifier.");
            }
            if (metadata.getProperty("http://purl.org/dc/elements/1.1/", "title") == null) {
                throw new PdfUAConformanceException("Metadata shall contain dc:title entry.");
            }
        }
        catch (XMPException e) {
            throw new PdfUAConformanceException("Document shall contain a XMP metadata stream.", e);
        }
    }

    @Override
    void checkOCProperties(PdfDictionary ocProperties) {
        if (ocProperties != null && !(ocProperties.get(PdfName.Configs) instanceof PdfArray)) {
            throw new PdfUAConformanceException("Optional Content properties configs shall be an array.");
        }
        super.checkOCProperties(ocProperties);
    }

    @Override
    void checkLogicalStructureInBMC(Stack<Tuple2<PdfName, PdfDictionary>> stack, Tuple2<PdfName, PdfDictionary> currentBmc, PdfDocument document) {
        this.checkStandardRoleMapping(currentBmc);
        super.checkLogicalStructureInBMC(stack, currentBmc, document);
    }

    @Override
    void checkNonSymbolicCmapSubtable(TrueTypeFont fontProgram) {
        if (fontProgram.isCmapPresent(3, 0) && fontProgram.getNumberOfCmaps() == 1 || fontProgram.getNumberOfCmaps() == 0) {
            throw new PdfUAConformanceException("For all non-symbolic TrueType fonts used for rendering, the embedded TrueType font program shall contain one or several non-symbolic cmap entries such that all necessary glyph lookups can be carried out.");
        }
    }

    @Override
    void checkSymbolicCmapSubtable(TrueTypeFont fontProgram) {
        if (!fontProgram.isCmapPresent(3, 0) && fontProgram.getNumberOfCmaps() != 1) {
            throw new PdfUAConformanceException("For symbolic TrueType fonts the \u201ccmap\u201d table in the embedded font program shall either contain exactly one encoding or it shall contain, at least, the Microsoft Symbol (Platform ID = 3, Encoding ID = 0) encoding.");
        }
    }

    private void checkStandardRoleMapping(Tuple2<PdfName, PdfDictionary> tag) {
        PdfNamespace namespace = this.tagStructureContext.getDocumentDefaultNamespace();
        String role = tag.getFirst().getValue();
        if (!"Artifact".equals(role) && !this.tagStructureContext.checkIfRoleShallBeMappedToStandardRole(role, namespace)) {
            throw new PdfUAConformanceException(MessageFormatUtil.format("\"{0}\" tag mapping does not terminate with a standard type.", role));
        }
    }

    private void checkCatalog(PdfCatalog catalog) {
        PdfBoolean markInfoSuspects;
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        if (!catalogDict.containsKey(PdfName.Metadata)) {
            throw new PdfUAConformanceException("Metadata shall be present in the catalog dictionary");
        }
        this.checkLang(catalog);
        PdfCheckersUtil.validateLang(catalogDict, EXCEPTION_SUPPLIER);
        PdfDictionary markInfo = catalogDict.getAsDictionary(PdfName.MarkInfo);
        if (markInfo != null && markInfo.containsKey(PdfName.Suspects) && (markInfoSuspects = markInfo.getAsBoolean(PdfName.Suspects)) != null && markInfoSuspects.getValue()) {
            throw new PdfUAConformanceException("Suspects entry in mark info dictionary shall not have a value of true.");
        }
        this.checkViewerPreferences(catalog);
        this.checkMetadata(catalog);
        this.checkOCProperties(catalogDict.getAsDictionary(PdfName.OCProperties));
    }

    private void checkStructureTreeRoot(PdfStructTreeRoot structTreeRoot) {
        PdfDictionary roleMap = structTreeRoot.getRoleMap();
        for (Map.Entry<PdfName, PdfObject> entry : roleMap.entrySet()) {
            String role = entry.getKey().getValue();
            IRoleMappingResolver roleMappingResolver = this.pdfDocument.getTagStructureContext().getRoleMappingResolver(role);
            if (!roleMappingResolver.currentRoleIsStandard()) continue;
            throw new PdfUAConformanceException("One or more standard types are remapped.");
        }
        TagTreeIterator tagTreeIterator = new TagTreeIterator(structTreeRoot);
        tagTreeIterator.addHandler(new GraphicsCheckUtil.GraphicsHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA1FormulaChecker.PdfUA1FormulaTagHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA1NotesChecker.PdfUA1NotesTagHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA1HeadingsChecker.PdfUA1HeadingHandler(this.context));
        tagTreeIterator.addHandler(new TableCheckUtil.TableHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA1AnnotationChecker.PdfUA1AnnotationHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA1FormChecker.PdfUA1FormTagHandler(this.context));
        tagTreeIterator.addHandler(new PdfUA1ListChecker.PdfUA1ListHandler(this.context));
        tagTreeIterator.traverse();
    }

    private void checkCrypto(PdfDictionary encryptionDictionary) {
        if (encryptionDictionary != null) {
            if (!(encryptionDictionary.get(PdfName.P) instanceof PdfNumber)) {
                throw new PdfUAConformanceException("Permissions are absent in pdf encryption dictionary.");
            }
            int permissions = (int)((PdfNumber)encryptionDictionary.get(PdfName.P)).longValue();
            if ((0x200 & permissions) == 0) {
                throw new PdfUAConformanceException("10th bit of P value of Encryption dictionary should be 1 if the document is tagged.");
            }
        }
    }

    private void checkPdfObject(PdfObject obj) {
        PdfDictionary dict;
        PdfName type;
        if (obj.getType() == 3 && PdfName.Filespec.equals(type = (dict = (PdfDictionary)obj).getAsName(PdfName.Type))) {
            this.checkFileSpec(dict);
        }
    }
}

