/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.minmaxwidth;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinMaxWidthUtils {
    private static final float eps = 0.01f;
    private static final float max = 32760.0f;

    public static float getEps() {
        return 0.01f;
    }

    public static float getInfWidth() {
        return 32760.0f;
    }

    public static float getInfHeight() {
        return 1000000.0f;
    }

    public static boolean isEqual(double x, double y) {
        return Math.abs(x - y) < (double)0.01f;
    }

    public static MinMaxWidth countDefaultMinMaxWidth(IRenderer renderer) {
        LayoutResult result = renderer.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), MinMaxWidthUtils.getInfHeight()))));
        return result.getStatus() == 3 ? new MinMaxWidth() : new MinMaxWidth(0.0f, result.getOccupiedArea().getBBox().getWidth(), 0.0f);
    }

    public static MinMaxWidth countDefaultMinMaxWidth(IRenderer renderer, float areaMaxWidth) {
        LayoutResult result = renderer.layout(new LayoutContext(new LayoutArea(1, new Rectangle(areaMaxWidth, MinMaxWidthUtils.getInfHeight()))));
        return result.getStatus() == 3 ? new MinMaxWidth() : new MinMaxWidth(0.0f, result.getOccupiedArea().getBBox().getWidth(), 0.0f);
    }

    public static float getBorderWidth(IPropertyContainer element) {
        Border rightBorder = (Border)element.getProperty(12);
        Border leftBorder = (Border)element.getProperty(11);
        float rightBorderWidth = rightBorder != null ? rightBorder.getWidth() : 0.0f;
        float leftBorderWidth = leftBorder != null ? leftBorder.getWidth() : 0.0f;
        return rightBorderWidth + leftBorderWidth;
    }

    public static float getMarginsWidth(IPropertyContainer element) {
        UnitValue leftMargin;
        UnitValue rightMargin = (UnitValue)element.getProperty(45);
        if (null != rightMargin && !rightMargin.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MinMaxWidthUtils.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 45));
        }
        if (null != (leftMargin = (UnitValue)element.getProperty(44)) && !leftMargin.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MinMaxWidthUtils.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 44));
        }
        float rightMarginWidth = rightMargin != null ? rightMargin.getValue() : 0.0f;
        float leftMarginWidth = leftMargin != null ? leftMargin.getValue() : 0.0f;
        return rightMarginWidth + leftMarginWidth;
    }

    public static float getPaddingWidth(IPropertyContainer element) {
        UnitValue leftPadding;
        UnitValue rightPadding = (UnitValue)element.getProperty(49);
        if (null != rightPadding && !rightPadding.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MinMaxWidthUtils.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 49));
        }
        if (null != (leftPadding = (UnitValue)element.getProperty(48)) && !leftPadding.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MinMaxWidthUtils.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 48));
        }
        float rightPaddingWidth = rightPadding != null ? rightPadding.getValue() : 0.0f;
        float leftPaddingWidth = leftPadding != null ? leftPadding.getValue() : 0.0f;
        return rightPaddingWidth + leftPaddingWidth;
    }
}

