/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.properties.TransparentColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Border {
    public static final Border NO_BORDER = null;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DOUBLE = 3;
    public static final int ROUND_DOTS = 4;
    public static final int _3D_GROOVE = 5;
    public static final int _3D_INSET = 6;
    public static final int _3D_OUTSET = 7;
    public static final int _3D_RIDGE = 8;
    public static final int DASHED_FIXED = 9;
    private static final int ARC_RIGHT_DEGREE = 0;
    private static final int ARC_TOP_DEGREE = 90;
    private static final int ARC_LEFT_DEGREE = 180;
    private static final int ARC_BOTTOM_DEGREE = 270;
    private static final int ARC_QUARTER_CLOCKWISE_EXTENT = -90;
    protected TransparentColor transparentColor;
    protected float width;
    protected int type;
    private int hash;

    protected Border(float width) {
        this(ColorConstants.BLACK, width);
    }

    protected Border(Color color, float width) {
        this.transparentColor = new TransparentColor(color);
        this.width = width;
    }

    protected Border(Color color, float width, float opacity) {
        this.transparentColor = new TransparentColor(color, opacity);
        this.width = width;
    }

    public abstract void draw(PdfCanvas var1, float var2, float var3, float var4, float var5, Side var6, float var7, float var8);

    public void draw(PdfCanvas canvas, Rectangle rectangle) {
        float left = rectangle.getX();
        float bottom = rectangle.getY();
        float right = rectangle.getX() + rectangle.getWidth();
        float top = rectangle.getY() + rectangle.getHeight();
        this.draw(canvas, left, top, right, top, Side.TOP, this.width, this.width);
        this.draw(canvas, right, top, right, bottom, Side.RIGHT, this.width, this.width);
        this.draw(canvas, right, bottom, left, bottom, Side.BOTTOM, this.width, this.width);
        this.draw(canvas, left, bottom, left, top, Side.LEFT, this.width, this.width);
    }

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderRadius, Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        this.draw(canvas, x1, y1, x2, y2, borderRadius, borderRadius, borderRadius, borderRadius, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        Logger logger = LoggerFactory.getLogger(Border.class);
        logger.warn(MessageFormatUtil.format("Method {0} is not implemented by default: please, override and implement it. {1} will be used instead.", "Border#draw(PdfCanvas, float, float, float, float, float, float, float, float, Side, float, float", "Border#draw(PdfCanvas, float, float, float, float, Side, float, float)"));
        this.draw(canvas, x1, y1, x2, y2, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    public abstract void drawCellBorder(PdfCanvas var1, float var2, float var3, float var4, float var5, Side var6);

    public abstract int getType();

    public Color getColor() {
        return this.transparentColor.getColor();
    }

    public float getOpacity() {
        return this.transparentColor.getOpacity();
    }

    public float getWidth() {
        return this.width;
    }

    public void setColor(Color color) {
        this.transparentColor = new TransparentColor(color, this.transparentColor.getOpacity());
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Border) {
            Border anotherBorder = (Border)anObject;
            return anotherBorder.getType() == this.getType() && anotherBorder.getColor().equals(this.getColor()) && anotherBorder.getWidth() == this.getWidth() && anotherBorder.transparentColor.getOpacity() == this.transparentColor.getOpacity();
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = (int)this.getWidth() * 31 + this.getColor().hashCode();
            this.hash = h = h * 31 + (int)this.transparentColor.getOpacity();
        }
        return h;
    }

    protected Side getBorderSide(float x1, float y1, float x2, float y2, Side defaultSide) {
        boolean isLeft = false;
        boolean isRight = false;
        if (Math.abs(y2 - y1) > 5.0E-4f) {
            isLeft = y2 - y1 > 0.0f;
            isRight = y2 - y1 < 0.0f;
        }
        boolean isTop = false;
        boolean isBottom = false;
        if (Math.abs(x2 - x1) > 5.0E-4f) {
            isTop = x2 - x1 > 0.0f;
            boolean bl = isBottom = x2 - x1 < 0.0f;
        }
        if (isTop) {
            return isLeft ? Side.LEFT : Side.TOP;
        }
        if (isRight) {
            return Side.RIGHT;
        }
        if (isBottom) {
            return Side.BOTTOM;
        }
        if (isLeft) {
            return Side.LEFT;
        }
        return defaultSide;
    }

    protected Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        if (gapsNum == 0.0) {
            return initialGap;
        }
        return (float)(distance / gapsNum);
    }

    protected void drawDiscontinuousBorders(PdfCanvas canvas, Rectangle boundingRectangle, float[] horizontalRadii, float[] verticalRadii, Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        double x1 = boundingRectangle.getX();
        double y1 = boundingRectangle.getY();
        double x2 = boundingRectangle.getRight();
        double y2 = boundingRectangle.getTop();
        double horizontalRadius1 = horizontalRadii[0];
        double horizontalRadius2 = horizontalRadii[1];
        double verticalRadius1 = verticalRadii[0];
        double verticalRadius2 = verticalRadii[1];
        double x0 = boundingRectangle.getX();
        double y0 = boundingRectangle.getY();
        double x3 = boundingRectangle.getRight();
        double y3 = boundingRectangle.getTop();
        double widthHalf = (double)this.width / 2.0;
        Side borderSide = this.getBorderSide((float)x1, (float)y1, (float)x2, (float)y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                double innerRadiusBefore = Math.max(0.0, horizontalRadius1 - (double)borderWidthBefore);
                double innerRadiusFirst = Math.max(0.0, verticalRadius1 - (double)this.width);
                double innerRadiusSecond = Math.max(0.0, verticalRadius2 - (double)this.width);
                double innerRadiusAfter = Math.max(0.0, horizontalRadius2 - (double)borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 - (double)borderWidthBefore, y1 + (double)this.width), new Point(x1, y1), new Point(x0 -= (double)(borderWidthBefore / 2.0f), y0 -= innerRadiusFirst), new Point(x0 + 10.0, y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 + (double)borderWidthAfter, y2 + (double)this.width), new Point(x2, y2), new Point(x3 += (double)(borderWidthAfter / 2.0f), y3 -= innerRadiusSecond), new Point(x3 - 10.0, y3));
                if (clipPoint1.getX() > clipPoint2.getX()) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 - (double)borderWidthBefore, y1 + (double)this.width), clipPoint1, clipPoint2, new Point(x2 + (double)borderWidthAfter, y2 + (double)this.width));
                    canvas.moveTo(x1 - (double)borderWidthBefore, y1 + (double)this.width).lineTo(clipPoint.getX(), clipPoint.getY()).lineTo(x2 + (double)borderWidthAfter, y2 + (double)this.width).lineTo(x1 - (double)borderWidthBefore, y1 + (double)this.width);
                } else {
                    canvas.moveTo(x1 - (double)borderWidthBefore, y1 + (double)this.width).lineTo(clipPoint1.getX(), clipPoint1.getY()).lineTo(clipPoint2.getX(), clipPoint2.getY()).lineTo(x2 + (double)borderWidthAfter, y2 + (double)this.width).lineTo(x1 - (double)borderWidthBefore, y1 + (double)this.width);
                }
                canvas.clip().endPath();
                canvas.arc(x0, y0 - innerRadiusFirst, (x1 += innerRadiusBefore) + innerRadiusBefore, y1 += widthHalf, 180.0, -90.0).arcContinuous((x2 -= innerRadiusAfter) - innerRadiusAfter, y2 += widthHalf, x3, y3 - innerRadiusSecond, 90.0, -90.0);
                break;
            }
            case RIGHT: {
                double innerRadiusBefore = Math.max(0.0, verticalRadius1 - (double)borderWidthBefore);
                double innerRadiusFirst = Math.max(0.0, horizontalRadius1 - (double)this.width);
                double innerRadiusSecond = Math.max(0.0, horizontalRadius2 - (double)this.width);
                double innerRadiusAfter = Math.max(0.0, verticalRadius2 - (double)borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 + (double)this.width, y1 + (double)borderWidthBefore), new Point(x1, y1), new Point(x0 -= innerRadiusFirst, y0 += (double)(borderWidthBefore / 2.0f)), new Point(x0, y0 - 10.0));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 + (double)this.width, y2 - (double)borderWidthAfter), new Point(x2, y2), new Point(x3 -= innerRadiusSecond, y3 -= (double)(borderWidthAfter / 2.0f)), new Point(x3, y3 - 10.0));
                if (clipPoint1.getY() < clipPoint2.getY()) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 + (double)this.width, y1 + (double)borderWidthBefore), clipPoint1, clipPoint2, new Point(x2 + (double)this.width, y2 - (double)borderWidthAfter));
                    canvas.moveTo(x1 + (double)this.width, y1 + (double)borderWidthBefore).lineTo(clipPoint.getX(), clipPoint.getY()).lineTo(x2 + (double)this.width, y2 - (double)borderWidthAfter).lineTo(x1 + (double)this.width, y1 + (double)borderWidthBefore).clip().endPath();
                } else {
                    canvas.moveTo(x1 + (double)this.width, y1 + (double)borderWidthBefore).lineTo(clipPoint1.getX(), clipPoint1.getY()).lineTo(clipPoint2.getX(), clipPoint2.getY()).lineTo(x2 + (double)this.width, y2 - (double)borderWidthAfter).lineTo(x1 + (double)this.width, y1 + (double)borderWidthBefore).clip().endPath();
                }
                canvas.clip().endPath();
                canvas.arc(x0 - innerRadiusFirst, y0, x1 += widthHalf, (y1 -= innerRadiusBefore) - innerRadiusBefore, 90.0, -90.0).arcContinuous(x2 += widthHalf, (y2 += innerRadiusAfter) + innerRadiusAfter, x3 - innerRadiusSecond, y3, 0.0, -90.0);
                break;
            }
            case BOTTOM: {
                double innerRadiusBefore = Math.max(0.0, horizontalRadius1 - (double)borderWidthBefore);
                double innerRadiusFirst = Math.max(0.0, verticalRadius1 - (double)this.width);
                double innerRadiusSecond = Math.max(0.0, verticalRadius2 - (double)this.width);
                double innerRadiusAfter = Math.max(0.0, horizontalRadius2 - (double)borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 + (double)borderWidthBefore, y1 - (double)this.width), new Point(x1, y1), new Point(x0 += (double)(borderWidthBefore / 2.0f), y0 += innerRadiusFirst), new Point(x0 - 10.0, y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 - (double)borderWidthAfter, y2 - (double)this.width), new Point(x2, y2), new Point(x3 -= (double)(borderWidthAfter / 2.0f), y3 += innerRadiusSecond), new Point(x3 + 10.0, y3));
                if (clipPoint1.getX() < clipPoint2.getX()) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 + (double)borderWidthBefore, y1 - (double)this.width), clipPoint1, clipPoint2, new Point(x2 - (double)borderWidthAfter, y2 - (double)this.width));
                    canvas.moveTo(x1 + (double)borderWidthBefore, y1 - (double)this.width).lineTo(clipPoint.getX(), clipPoint.getY()).lineTo(x2 - (double)borderWidthAfter, y2 - (double)this.width).lineTo(x1 + (double)borderWidthBefore, y1 - (double)this.width);
                } else {
                    canvas.moveTo(x1 + (double)borderWidthBefore, y1 - (double)this.width).lineTo(clipPoint1.getX(), clipPoint1.getY()).lineTo(clipPoint2.getX(), clipPoint2.getY()).lineTo(x2 - (double)borderWidthAfter, y2 - (double)this.width).lineTo(x1 + (double)borderWidthBefore, y1 - (double)this.width);
                }
                canvas.clip().endPath();
                canvas.arc(x0, y0 + innerRadiusFirst, (x1 -= innerRadiusBefore) - innerRadiusBefore, y1 -= widthHalf, 0.0, -90.0).arcContinuous((x2 += innerRadiusAfter) + innerRadiusAfter, y2 -= widthHalf, x3, y3 + innerRadiusSecond, 270.0, -90.0);
                break;
            }
            case LEFT: {
                double innerRadiusBefore = Math.max(0.0, verticalRadius1 - (double)borderWidthBefore);
                double innerRadiusFirst = Math.max(0.0, horizontalRadius1 - (double)this.width);
                double innerRadiusSecond = Math.max(0.0, horizontalRadius2 - (double)this.width);
                double innerRadiusAfter = Math.max(0.0, verticalRadius2 - (double)borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 - (double)this.width, y1 - (double)borderWidthBefore), new Point(x1, y1), new Point(x0 += innerRadiusFirst, y0 -= (double)(borderWidthBefore / 2.0f)), new Point(x0, y0 + 10.0));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 - (double)this.width, y2 + (double)borderWidthAfter), new Point(x2, y2), new Point(x3 += innerRadiusSecond, y3 += (double)(borderWidthAfter / 2.0f)), new Point(x3, y3 + 10.0));
                if (clipPoint1.getY() > clipPoint2.getY()) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 - (double)this.width, y1 - (double)borderWidthBefore), clipPoint1, clipPoint2, new Point(x2 - (double)this.width, y2 + (double)borderWidthAfter));
                    canvas.moveTo(x1 - (double)this.width, y1 - (double)borderWidthBefore).lineTo(clipPoint.getX(), clipPoint.getY()).lineTo(x2 - (double)this.width, y2 + (double)borderWidthAfter).lineTo(x1 - (double)this.width, y1 - (double)borderWidthBefore);
                } else {
                    canvas.moveTo(x1 - (double)this.width, y1 - (double)borderWidthBefore).lineTo(clipPoint1.getX(), clipPoint1.getY()).lineTo(clipPoint2.getX(), clipPoint2.getY()).lineTo(x2 - (double)this.width, y2 + (double)borderWidthAfter).lineTo(x1 - (double)this.width, y1 - (double)borderWidthBefore);
                }
                canvas.clip().endPath();
                canvas.arc(x0 + innerRadiusFirst, y0, x1 -= widthHalf, (y1 += innerRadiusBefore) + innerRadiusBefore, 270.0, -90.0).arcContinuous(x2 -= widthHalf, (y2 -= innerRadiusAfter) - innerRadiusAfter, x3 + innerRadiusSecond, y3, 180.0, -90.0);
                break;
            }
        }
        canvas.stroke().restoreState();
    }

    protected float[] getStartingPointsForBorderSide(float x1, float y1, float x2, float y2, Side defaultSide) {
        float widthHalf = this.width / 2.0f;
        Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
                break;
            }
        }
        return new float[]{x1, y1, x2, y2};
    }

    public static enum Side {
        NONE,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

