/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.checkers;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.utils.checkers.BCP47Validator;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.properties.XMPProperty;
import java.io.ByteArrayInputStream;
import java.util.function.Function;

public final class PdfCheckersUtil {
    private PdfCheckersUtil() {
    }

    public static void validateLang(PdfDictionary catalogDict, Function<String, PdfException> exceptionSupplier) {
        if (!BCP47Validator.validate(catalogDict.get(PdfName.Lang).toString())) {
            throw exceptionSupplier.apply("Document does not contain valid lang entry.");
        }
    }

    public static void checkMetadata(PdfDictionary catalog, PdfConformance conformance, Function<String, PdfException> exceptionSupplier) {
        if (!catalog.containsKey(PdfName.Metadata)) {
            throw exceptionSupplier.apply("Metadata shall be present in the catalog dictionary.");
        }
        try {
            String expectedPart;
            PdfStream xmpMetadata = catalog.getAsStream(PdfName.Metadata);
            if (xmpMetadata == null) {
                throw exceptionSupplier.apply("Document metadata value shall be a valid XMP metadata stream.");
            }
            XMPMeta metadata = XMPMetaFactory.parse(new ByteArrayInputStream(xmpMetadata.getBytes()));
            String NS_ID = conformance.isPdfA() ? "http://www.aiim.org/pdfa/ns/id/" : "http://www.aiim.org/pdfua/ns/id/";
            XMPProperty actualPart = metadata.getProperty(NS_ID, "part");
            String string = expectedPart = conformance.isPdfA() ? conformance.getAConformance().getPart() : conformance.getUAConformance().getPart();
            if (actualPart == null || !expectedPart.equals(actualPart.getValue())) {
                throw exceptionSupplier.apply(MessageFormatUtil.format("XMP metadata header shall contain version identifier pdfaid:part with value {0} instead of {1}.", expectedPart, actualPart != null && actualPart.getValue().isEmpty() ? null : actualPart));
            }
            XMPProperty rev = metadata.getProperty(NS_ID, "rev");
            if (rev == null || !PdfCheckersUtil.isValidXmpRevision(rev.getValue())) {
                throw exceptionSupplier.apply("XMP metadata header shall contain version identifier pdfaid:rev with four digit integer value");
            }
        }
        catch (XMPException e) {
            throw exceptionSupplier.apply("Document metadata value shall be a valid XMP metadata stream.");
        }
    }

    public static PdfArray getFormFields(PdfArray array) {
        PdfArray fields = new PdfArray();
        for (PdfObject field : array) {
            PdfArray kids = ((PdfDictionary)field).getAsArray(PdfName.Kids);
            fields.add(field);
            if (kids == null) continue;
            fields.addAll(PdfCheckersUtil.getFormFields(kids));
        }
        return fields;
    }

    private static boolean isValidXmpRevision(String value) {
        if (value == null || value.length() != 4) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }
}

