/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagutils.ITagTreeIteratorHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TagTreeIterator {
    private final IStructureNode pointer;
    private final Set<ITagTreeIteratorHandler> handlerList;
    private final TreeTraversalOrder traversalOrder;

    public TagTreeIterator(IStructureNode tagTreePointer) {
        this(tagTreePointer, TreeTraversalOrder.PRE_ORDER);
    }

    public TagTreeIterator(IStructureNode tagTreePointer, TreeTraversalOrder traversalOrder) {
        if (tagTreePointer == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format("{0} should not be null.", "tagTreepointer"));
        }
        if (traversalOrder == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format("{0} should not be null.", "traversalOrder"));
        }
        this.pointer = tagTreePointer;
        this.traversalOrder = traversalOrder;
        this.handlerList = new HashSet<ITagTreeIteratorHandler>();
    }

    public TagTreeIterator addHandler(ITagTreeIteratorHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format("{0} should not be null.", "handler"));
        }
        this.handlerList.add(handler);
        return this;
    }

    public void traverse() {
        this.traverse(this.pointer);
    }

    private void traverse(IStructureNode elem) {
        List<IStructureNode> kids;
        for (ITagTreeIteratorHandler handler : this.handlerList) {
            if (handler.accept(elem)) continue;
            return;
        }
        if (this.traversalOrder == TreeTraversalOrder.PRE_ORDER) {
            for (ITagTreeIteratorHandler handler : this.handlerList) {
                handler.processElement(elem);
            }
        }
        if ((kids = elem.getKids()) != null) {
            for (IStructureNode kid : kids) {
                this.traverse(kid);
            }
        }
        if (this.traversalOrder == TreeTraversalOrder.POST_ORDER) {
            for (ITagTreeIteratorHandler handler : this.handlerList) {
                handler.processElement(elem);
            }
        }
    }

    public static enum TreeTraversalOrder {
        PRE_ORDER,
        POST_ORDER;

    }
}

