/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.colorspace;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.colorspace.shading.AbstractPdfShading;

public abstract class PdfPattern
extends PdfObjectWrapper<PdfDictionary> {
    protected PdfPattern(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfPattern getPatternInstance(PdfDictionary pdfObject) {
        PdfNumber type = pdfObject.getAsNumber(PdfName.PatternType);
        if (type.intValue() == 1 && pdfObject instanceof PdfStream) {
            return new Tiling((PdfStream)pdfObject);
        }
        if (type.intValue() == 2) {
            return new Shading(pdfObject);
        }
        throw new IllegalArgumentException("pdfObject");
    }

    public PdfArray getMatrix() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Matrix);
    }

    public void setMatrix(PdfArray matrix) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Matrix, matrix);
        this.setModified();
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    public static class Shading
    extends PdfPattern {
        public Shading(PdfDictionary pdfObject) {
            super(pdfObject);
        }

        public Shading(AbstractPdfShading shading) {
            super(new PdfDictionary());
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Pattern);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.PatternType, new PdfNumber(2));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Shading, (PdfObject)shading.getPdfObject());
        }

        public PdfDictionary getShading() {
            return (PdfDictionary)((PdfDictionary)this.getPdfObject()).get(PdfName.Shading);
        }

        public void setShading(AbstractPdfShading shading) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Shading, (PdfObject)shading.getPdfObject());
            this.setModified();
        }

        public void setShading(PdfDictionary shading) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Shading, shading);
            this.setModified();
        }
    }

    public static class Tiling
    extends PdfPattern {
        private PdfResources resources = null;

        public Tiling(PdfStream pdfObject) {
            super(pdfObject);
        }

        public Tiling(float width, float height) {
            this(width, height, true);
        }

        public Tiling(float width, float height, boolean colored) {
            this(new Rectangle(width, height), colored);
        }

        public Tiling(Rectangle bbox) {
            this(bbox, true);
        }

        public Tiling(Rectangle bbox, boolean colored) {
            this(bbox, bbox.getWidth(), bbox.getHeight(), colored);
        }

        public Tiling(float width, float height, float xStep, float yStep) {
            this(width, height, xStep, yStep, true);
        }

        public Tiling(float width, float height, float xStep, float yStep, boolean colored) {
            this(new Rectangle(width, height), xStep, yStep, colored);
        }

        public Tiling(Rectangle bbox, float xStep, float yStep) {
            this(bbox, xStep, yStep, true);
        }

        public Tiling(Rectangle bbox, float xStep, float yStep, boolean colored) {
            super(new PdfStream());
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Pattern);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.PatternType, new PdfNumber(1));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.PaintType, new PdfNumber(colored ? 1 : 2));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.TilingType, new PdfNumber(1));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BBox, new PdfArray(bbox));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.XStep, new PdfNumber(xStep));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.YStep, new PdfNumber(yStep));
            this.resources = new PdfResources();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Resources, (PdfObject)this.resources.getPdfObject());
        }

        public boolean isColored() {
            return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.PaintType).intValue() == 1;
        }

        public void setColored(boolean colored) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.PaintType, new PdfNumber(colored ? 1 : 2));
            this.setModified();
        }

        public int getTilingType() {
            return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.TilingType).intValue();
        }

        public void setTilingType(int tilingType) {
            if (tilingType != 1 && tilingType != 2 && tilingType != 3) {
                throw new IllegalArgumentException("tilingType");
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.TilingType, new PdfNumber(tilingType));
            this.setModified();
        }

        public Rectangle getBBox() {
            return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.BBox).toRectangle();
        }

        public void setBBox(Rectangle bbox) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BBox, new PdfArray(bbox));
            this.setModified();
        }

        public float getXStep() {
            return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.XStep).floatValue();
        }

        public void setXStep(float xStep) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.XStep, new PdfNumber(xStep));
            this.setModified();
        }

        public float getYStep() {
            return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.YStep).floatValue();
        }

        public void setYStep(float yStep) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.YStep, new PdfNumber(yStep));
            this.setModified();
        }

        public PdfResources getResources() {
            if (this.resources == null) {
                PdfDictionary resourcesDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Resources);
                if (resourcesDict == null) {
                    resourcesDict = new PdfDictionary();
                    ((PdfDictionary)this.getPdfObject()).put(PdfName.Resources, resourcesDict);
                }
                this.resources = new PdfResources(resourcesDict);
            }
            return this.resources;
        }

        @Override
        public void flush() {
            this.resources = null;
            super.flush();
        }

        public static class TilingType {
            public static final int CONSTANT_SPACING = 1;
            public static final int NO_DISTORTION = 2;
            public static final int CONSTANT_SPACING_AND_FASTER_TILING = 3;
        }

        public static class PaintType {
            public static final int COLORED = 1;
            public static final int UNCOLORED = 2;
        }
    }
}

