/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.utils.ICopyFilter;

public class PdfIndirectReference
extends PdfObject
implements Comparable<PdfIndirectReference> {
    private static final int LENGTH_OF_INDIRECTS_CHAIN = 31;
    protected final int objNr;
    protected int genNr;
    protected PdfObject refersTo = null;
    protected int objectStreamNumber = 0;
    protected long offsetOrIndex = 0L;
    protected PdfDocument pdfDocument = null;

    protected PdfIndirectReference(PdfDocument doc, int objNr) {
        this(doc, objNr, 0);
    }

    protected PdfIndirectReference(PdfDocument doc, int objNr, int genNr) {
        this.pdfDocument = doc;
        this.objNr = objNr;
        this.genNr = genNr;
    }

    protected PdfIndirectReference(PdfDocument doc, int objNr, int genNr, long offset) {
        this.pdfDocument = doc;
        this.objNr = objNr;
        this.genNr = genNr;
        this.offsetOrIndex = offset;
        assert (offset >= 0L);
    }

    public int getObjNumber() {
        return this.objNr;
    }

    public int getGenNumber() {
        return this.genNr;
    }

    public PdfObject getRefersTo() {
        return this.getRefersTo(true);
    }

    public PdfObject getRefersTo(boolean recursively) {
        if (!recursively) {
            if (!(this.refersTo != null || this.checkState((short)1) || this.checkState((short)8) || this.checkState((short)2) || this.getReader() == null)) {
                this.refersTo = this.getReader().readObject(this);
            }
            return this.refersTo;
        }
        PdfObject currentRefersTo = this.getRefersTo(false);
        for (int i = 0; i < 31 && currentRefersTo instanceof PdfIndirectReference; ++i) {
            currentRefersTo = ((PdfIndirectReference)currentRefersTo).getRefersTo(false);
        }
        return currentRefersTo;
    }

    protected void setRefersTo(PdfObject refersTo) {
        this.refersTo = refersTo;
    }

    public int getObjStreamNumber() {
        return this.objectStreamNumber;
    }

    public long getOffset() {
        return this.objectStreamNumber == 0 ? this.offsetOrIndex : -1L;
    }

    public int getIndex() {
        return this.objectStreamNumber == 0 ? -1 : (int)this.offsetOrIndex;
    }

    public boolean equals(Object o) {
        boolean documentsEquals;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfIndirectReference that = (PdfIndirectReference)o;
        boolean bl = documentsEquals = this.pdfDocument == that.pdfDocument;
        if (!documentsEquals) {
            documentsEquals = this.pdfDocument != null && that.pdfDocument != null && this.pdfDocument.getDocumentId() == that.pdfDocument.getDocumentId();
        }
        return this.objNr == that.objNr && this.genNr == that.genNr && documentsEquals;
    }

    public int hashCode() {
        int result = this.objNr;
        result = 31 * result + this.genNr;
        if (this.pdfDocument != null) {
            result = 31 * result + (int)this.pdfDocument.getDocumentId();
        }
        return result;
    }

    @Override
    public int compareTo(PdfIndirectReference o) {
        if (this.objNr == o.objNr) {
            if (this.genNr == o.genNr) {
                return this.comparePdfDocumentLinks(o);
            }
            return this.genNr > o.genNr ? 1 : -1;
        }
        return this.objNr > o.objNr ? 1 : -1;
    }

    @Override
    public byte getType() {
        return 5;
    }

    public PdfDocument getDocument() {
        return this.pdfDocument;
    }

    public void setFree() {
        this.getDocument().getXref().freeReference(this);
    }

    public boolean isFree() {
        return this.checkState((short)2);
    }

    public String toString() {
        StringBuilder states = new StringBuilder(" ");
        if (this.checkState((short)2)) {
            states.append("Free; ");
        }
        if (this.checkState((short)8)) {
            states.append("Modified; ");
        }
        if (this.checkState((short)32)) {
            states.append("MustBeFlushed; ");
        }
        if (this.checkState((short)4)) {
            states.append("Reading; ");
        }
        if (this.checkState((short)1)) {
            states.append("Flushed; ");
        }
        if (this.checkState((short)16)) {
            states.append("OriginalObjectStream; ");
        }
        if (this.checkState((short)128)) {
            states.append("ForbidRelease; ");
        }
        if (this.checkState((short)256)) {
            states.append("ReadOnly; ");
        }
        return MessageFormatUtil.format("{0} {1} R{2}", Integer.toString(this.getObjNumber()), Integer.toString(this.getGenNumber()), states.substring(0, states.length() - 1));
    }

    protected PdfWriter getWriter() {
        if (this.getDocument() != null) {
            return this.getDocument().getWriter();
        }
        return null;
    }

    protected PdfReader getReader() {
        if (this.getDocument() != null) {
            return this.getDocument().getReader();
        }
        return null;
    }

    @Override
    protected PdfObject newInstance() {
        return PdfNull.PDF_NULL;
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document, ICopyFilter copyFilter) {
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
    }

    @Override
    protected PdfObject setState(short state) {
        return super.setState(state);
    }

    void setObjStreamNumber(int objectStreamNumber) {
        this.objectStreamNumber = objectStreamNumber;
    }

    void setIndex(long index) {
        this.offsetOrIndex = index;
    }

    void setOffset(long offset) {
        this.offsetOrIndex = offset;
        this.objectStreamNumber = 0;
    }

    void fixOffset(long offset) {
        if (!this.isFree()) {
            this.offsetOrIndex = offset;
        }
    }

    private int comparePdfDocumentLinks(PdfIndirectReference toCompare) {
        long documentIdToCompare;
        if (this.pdfDocument == toCompare.pdfDocument) {
            return 0;
        }
        if (this.pdfDocument == null) {
            return -1;
        }
        if (toCompare.pdfDocument == null) {
            return 1;
        }
        long thisDocumentId = this.pdfDocument.getDocumentId();
        if (thisDocumentId == (documentIdToCompare = toCompare.pdfDocument.getDocumentId())) {
            return 0;
        }
        return thisDocumentId > documentIdToCompare ? 1 : -1;
    }
}

