/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFontStrategy {
    private final PdfDocument pdfDocument;
    private PdfFont defaultFont = null;

    public DefaultFontStrategy(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    public PdfFont getFont() {
        if (this.defaultFont == null) {
            try {
                this.defaultFont = PdfFontFactory.createFont();
                if (this.pdfDocument.getWriter() != null) {
                    this.defaultFont.makeIndirect(this.pdfDocument);
                }
            }
            catch (IOException e) {
                Logger logger = LoggerFactory.getLogger(DefaultFontStrategy.class);
                logger.error("Exception while creating default font (Helvetica, WinAnsi)", e);
                this.defaultFont = null;
            }
        }
        return this.defaultFont;
    }
}

