/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.di.pagetree;

import com.itextpdf.commons.datastructures.ISimpleList;
import com.itextpdf.commons.datastructures.NullUnlimitedList;
import com.itextpdf.commons.datastructures.SimpleArrayList;
import com.itextpdf.kernel.di.pagetree.IPageTreeListFactory;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;

public class DefaultPageTreeListFactory
implements IPageTreeListFactory {
    private final int maxEntriesBeforeSwitchingToNullUnlimitedList;

    public DefaultPageTreeListFactory(int maxEntriesBeforeSwitchingToNullUnlimitedList) {
        this.maxEntriesBeforeSwitchingToNullUnlimitedList = maxEntriesBeforeSwitchingToNullUnlimitedList;
    }

    @Override
    public <T> ISimpleList<T> createList(PdfDictionary pagesDictionary) {
        if (pagesDictionary == null) {
            return new SimpleArrayList();
        }
        PdfNumber count = pagesDictionary.getAsNumber(PdfName.Count);
        if (count == null) {
            return new NullUnlimitedList();
        }
        int countValue = count.intValue();
        if (countValue > this.maxEntriesBeforeSwitchingToNullUnlimitedList) {
            return new NullUnlimitedList();
        }
        if (countValue < 0) {
            return new NullUnlimitedList();
        }
        return new SimpleArrayList(countValue);
    }
}

