/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IAbstractElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.grid.AutoRepeatValue;
import com.itextpdf.layout.properties.grid.AutoValue;
import com.itextpdf.layout.properties.grid.BreadthValue;
import com.itextpdf.layout.properties.grid.FitContentValue;
import com.itextpdf.layout.properties.grid.FixedRepeatValue;
import com.itextpdf.layout.properties.grid.FlexValue;
import com.itextpdf.layout.properties.grid.GridFlow;
import com.itextpdf.layout.properties.grid.GridValue;
import com.itextpdf.layout.properties.grid.MaxContentValue;
import com.itextpdf.layout.properties.grid.MinContentValue;
import com.itextpdf.layout.properties.grid.MinMaxValue;
import com.itextpdf.layout.properties.grid.PercentValue;
import com.itextpdf.layout.properties.grid.PointValue;
import com.itextpdf.layout.properties.grid.TemplateValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GridApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridApplierUtil.class);
    private static final Pattern SPAN_PLACEMENT = Pattern.compile("^span\\s+(.+)$");
    private static final Map<Integer, Integer> propsMap = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> spansMap = new HashMap<Integer, Integer>();

    private GridApplierUtil() {
    }

    public static void applyGridItemProperties(Map<String, String> cssProps, IStylesContainer stylesContainer, IPropertyContainer element) {
        if (!(stylesContainer instanceof JsoupElementNode) || !(((JsoupElementNode)stylesContainer).parentNode() instanceof JsoupElementNode)) {
            return;
        }
        Map<String, String> parentStyles = ((JsoupElementNode)((JsoupElementNode)stylesContainer).parentNode()).getStyles();
        if (!"grid".equals(parentStyles.get("display"))) {
            return;
        }
        GridApplierUtil.applyGridArea(cssProps, element);
        GridApplierUtil.applyGridItemPlacement(cssProps.get("grid-column-end"), element, 147, 9);
        GridApplierUtil.applyGridItemPlacement(cssProps.get("grid-column-start"), element, 148, 9);
        GridApplierUtil.applyGridItemPlacement(cssProps.get("grid-row-end"), element, 149, 101);
        GridApplierUtil.applyGridItemPlacement(cssProps.get("grid-row-start"), element, 150, 101);
    }

    public static void applyGridContainerProperties(Map<String, String> cssProps, IPropertyContainer container, ProcessorContext context) {
        float emValue = CssDimensionParsingUtils.parseAbsoluteFontSize(cssProps.get("font-size"));
        float remValue = context.getCssContext().getRootFontSize();
        NamedAreas namedAreas = GridApplierUtil.applyNamedAreas(cssProps.get("grid-template-areas"), container);
        GridApplierUtil.applyTemplate(cssProps.get("grid-template-columns"), container, 145, emValue, remValue, namedAreas);
        GridApplierUtil.applyTemplate(cssProps.get("grid-template-rows"), container, 146, emValue, remValue, namedAreas);
        GridApplierUtil.applyAuto(cssProps.get("grid-auto-rows"), container, 151, emValue, remValue);
        GridApplierUtil.applyAuto(cssProps.get("grid-auto-columns"), container, 152, emValue, remValue);
        GridApplierUtil.applyFlow(cssProps.get("grid-auto-flow"), container);
        GridApplierUtil.applyGap(container, emValue, remValue, cssProps.get("column-gap"), 143);
        GridApplierUtil.applyGap(container, emValue, remValue, cssProps.get("grid-column-gap"), 143);
        GridApplierUtil.applyGap(container, emValue, remValue, cssProps.get("row-gap"), 153);
        GridApplierUtil.applyGap(container, emValue, remValue, cssProps.get("grid-row-gap"), 153);
    }

    private static void applyGap(IPropertyContainer container, float emValue, float remValue, String gap, int property) {
        UnitValue gapValue = CssDimensionParsingUtils.parseLengthValueToPt(gap, emValue, remValue);
        if (gapValue != null) {
            container.setProperty(property, Float.valueOf(gapValue.getValue()));
        }
    }

    private static void applyAuto(String autoStr, IPropertyContainer container, int property, float emValue, float remValue) {
        TemplateValue value;
        if (autoStr != null && (value = GridApplierUtil.parseTemplateValue(autoStr, emValue, remValue)) != null) {
            container.setProperty(property, value);
        }
    }

    private static void applyFlow(String flow, IPropertyContainer container) {
        GridFlow value = GridFlow.ROW;
        if (flow != null) {
            if (flow.contains("column")) {
                value = flow.contains("dense") ? GridFlow.COLUMN_DENSE : GridFlow.COLUMN;
            } else if (flow.contains("dense")) {
                value = GridFlow.ROW_DENSE;
            }
        }
        container.setProperty(154, (Object)value);
    }

    private static NamedAreas applyNamedAreas(String gridTemplateAreas, IPropertyContainer container) {
        if (gridTemplateAreas == null || "none".equals(gridTemplateAreas)) {
            return null;
        }
        NamedAreas namedAreas = GridApplierUtil.parseGridTemplateAreas(gridTemplateAreas);
        List<IElement> children = ((IAbstractElement)container).getChildren();
        for (IElement child : children) {
            Object propValue = child.getProperty(150);
            if (!(propValue instanceof String)) continue;
            namedAreas.setPlaceToElement((String)propValue, child);
        }
        return namedAreas;
    }

    private static void applyTemplate(String templateStr, IPropertyContainer container, int property, float emValue, float remValue, NamedAreas namedAreas) {
        int spanProperty;
        int endProperty;
        int startProperty;
        boolean applyColumns;
        if (templateStr != null && templateStr.contains("subgrid")) {
            LOGGER.warn("Subgrid value for grid-template-row\\columns isn't supported");
        }
        HashMap<String, List<Integer>> lineNumbersPerName = new HashMap();
        int namedAreaLength = 0;
        boolean bl = applyColumns = property == 145;
        if (namedAreas != null) {
            if (applyColumns) {
                lineNumbersPerName = namedAreas.getNamedColumnNumbers();
                namedAreaLength = namedAreas.getColumnsCount();
            } else {
                lineNumbersPerName = namedAreas.getNamedRowNumbers();
                namedAreaLength = namedAreas.getRowsCount();
            }
        }
        ArrayList<TemplateValue> templateResult = new ArrayList<TemplateValue>();
        int currentLine = 1;
        if (templateStr != null) {
            List<String> templateStrArray = CssUtils.extractShorthandProperties(templateStr).get(0);
            for (String str : templateStrArray) {
                TemplateValue value = GridApplierUtil.parseTemplateValue(str, emValue, remValue, lineNumbersPerName, currentLine);
                if (value == null) continue;
                templateResult.add(value);
                if (value instanceof FixedRepeatValue) {
                    currentLine += ((FixedRepeatValue)value).getRepeatCount() * ((FixedRepeatValue)value).getValues().size();
                    continue;
                }
                ++currentLine;
            }
            if (templateResult.isEmpty()) {
                LOGGER.warn(MessageFormatUtil.format("Grid template {0} value was not recognised", applyColumns ? "columns" : "rows"));
            } else {
                container.setProperty(property, templateResult);
            }
        }
        if (applyColumns) {
            startProperty = 148;
            endProperty = 147;
            spanProperty = 9;
        } else {
            startProperty = 150;
            endProperty = 149;
            spanProperty = 101;
        }
        List<IElement> children = ((IAbstractElement)container).getChildren();
        for (IElement child : children) {
            GridApplierUtil.substituteLinename(lineNumbersPerName, startProperty, child, Math.max(namedAreaLength + 1, currentLine), "-start");
            GridApplierUtil.substituteLinename(lineNumbersPerName, endProperty, child, Math.max(namedAreaLength + 1, currentLine), "-end");
            GridApplierUtil.substituteLinenameInSpan(lineNumbersPerName, startProperty, endProperty, spanProperty, child, Math.max(namedAreaLength + 1, currentLine));
        }
    }

    private static void substituteLinenameInSpan(Map<String, List<Integer>> lineNumbersPerName, int startProperty, int endProperty, int spanProperty, IElement child, int lastLineNumber) {
        int spanIdx;
        Object propValue = child.getProperty(spanProperty);
        if (!(propValue instanceof String)) {
            return;
        }
        child.deleteOwnProperty(spanProperty);
        Integer startPoint = (Integer)child.getProperty(startProperty);
        Integer endPoint = (Integer)child.getProperty(endProperty);
        if (startPoint == null && endPoint == null) {
            return;
        }
        Tuple2<Integer, String> parsedValue = GridApplierUtil.parseStringValue((String)propValue);
        int distance = parsedValue.getFirst();
        String strValue = parsedValue.getSecond();
        List<Integer> lineNumbers = lineNumbersPerName.get(strValue);
        if (lineNumbers == null || distance <= 0 || strValue == null) {
            return;
        }
        int direction = startPoint != null ? 1 : -1;
        int startPosition = startPoint != null ? startPoint.intValue() : endPoint.intValue();
        int start = -1;
        int correction = -direction;
        for (Integer lineNumber : lineNumbers) {
            ++start;
            if (startPosition > lineNumber) continue;
            if (startPosition != lineNumber) break;
            correction = 0;
            break;
        }
        if ((spanIdx = start + distance * direction + correction) < 0) {
            return;
        }
        int endPosition = spanIdx > lineNumbers.size() - 1 ? lastLineNumber + spanIdx - (lineNumbers.size() - 1) : lineNumbers.get(spanIdx);
        if (direction == 1) {
            child.setProperty(endProperty, endPosition);
        } else {
            child.setProperty(startProperty, endPosition);
        }
    }

    private static void substituteLinename(Map<String, List<Integer>> lineNumbersPerName, int property, IElement child, int lastLineNumber, String alternateLineNameSuffix) {
        Object propValue = child.getProperty(property);
        if (!(propValue instanceof String)) {
            return;
        }
        child.deleteOwnProperty(property);
        Tuple2<Integer, String> parsedValue = GridApplierUtil.parseStringValue((String)propValue);
        int idx = parsedValue.getFirst();
        String strValue = parsedValue.getSecond();
        if (idx == 0 || strValue == null) {
            return;
        }
        List<Integer> lineNumbers = lineNumbersPerName.get(strValue);
        if (lineNumbers == null) {
            lineNumbers = lineNumbersPerName.get(strValue + alternateLineNameSuffix);
        }
        if (lineNumbers == null) {
            return;
        }
        if (idx > lineNumbers.size()) {
            child.setProperty(property, lastLineNumber + idx - lineNumbers.size());
            return;
        }
        if (Math.abs(idx) > lineNumbers.size()) {
            LOGGER.error("Adding grid lines to the left or to the top is not supported");
            return;
        }
        if (idx < 0) {
            idx = lineNumbers.size() + idx + 1;
        }
        child.setProperty(property, lineNumbers.get(idx - 1));
    }

    private static Tuple2<Integer, String> parseStringValue(String strPropValue) {
        String[] propValues = strPropValue.split("\\s+");
        int idx = 1;
        String strValue = null;
        if (propValues.length == 1) {
            strValue = propValues[0];
        } else if (propValues.length == 2) {
            Integer i;
            Integer i0 = CssDimensionParsingUtils.parseInteger(propValues[0]);
            Integer i1 = CssDimensionParsingUtils.parseInteger(propValues[1]);
            Integer n = i = i0 != null ? i0 : i1;
            if (i != null) {
                idx = i;
            }
            strValue = i0 != null ? propValues[1] : propValues[0];
        }
        return new Tuple2<Integer, String>(idx, strValue);
    }

    private static TemplateValue parseTemplateValue(String str, float emValue, float remValue) {
        UnitValue unit = CssDimensionParsingUtils.parseLengthValueToPt(str, emValue, remValue);
        if (unit != null) {
            if (unit.isPointValue()) {
                return new PointValue(unit.getValue());
            }
            return new PercentValue(unit.getValue());
        }
        if ("min-content".equals(str)) {
            return MinContentValue.VALUE;
        }
        if ("max-content".equals(str)) {
            return MaxContentValue.VALUE;
        }
        if ("auto".equals(str)) {
            return AutoValue.VALUE;
        }
        Float fr = CssDimensionParsingUtils.parseFlex(str);
        if (fr != null) {
            return new FlexValue(fr.floatValue());
        }
        if (GridApplierUtil.determineFunction(str, "fit-content")) {
            return GridApplierUtil.parseFitContent(str, emValue, remValue);
        }
        if (GridApplierUtil.determineFunction(str, "minmax")) {
            return GridApplierUtil.parseMinMax(str, emValue, remValue);
        }
        return null;
    }

    private static TemplateValue parseTemplateValue(String str, float emValue, float remValue, Map<String, List<Integer>> lineNumbersPerName, int currentLine) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            String[] linenames;
            String strStripped = str.substring(1, str.length() - 1);
            for (String linename : linenames = strStripped.trim().split("\\s+")) {
                if (!lineNumbersPerName.containsKey(linename)) {
                    lineNumbersPerName.put(linename, new ArrayList(1));
                }
                lineNumbersPerName.get(linename).add(currentLine);
            }
            return null;
        }
        if (GridApplierUtil.determineFunction(str, "repeat")) {
            return GridApplierUtil.parseRepeat(str, emValue, remValue, lineNumbersPerName, currentLine);
        }
        return GridApplierUtil.parseTemplateValue(str, emValue, remValue);
    }

    private static FitContentValue parseFitContent(String str, float emValue, float remValue) {
        UnitValue length = CssDimensionParsingUtils.parseLengthValueToPt(str.substring("fit-content".length() + 1, str.length() - 1), emValue, remValue);
        if (length == null) {
            return null;
        }
        return new FitContentValue(length);
    }

    private static boolean determineFunction(String str, String function) {
        return str.startsWith(function) && str.length() > function.length() + 2;
    }

    private static TemplateValue parseMinMax(String str, float emValue, float remValue) {
        int parameterSeparator = str.indexOf(44);
        if (parameterSeparator < 0) {
            return null;
        }
        TemplateValue min = GridApplierUtil.parseTemplateValue(str.substring("minmax".length() + 1, parameterSeparator).trim(), emValue, remValue);
        TemplateValue max = GridApplierUtil.parseTemplateValue(str.substring(parameterSeparator + 1, str.length() - 1).trim(), emValue, remValue);
        if (!(min instanceof BreadthValue) || !(max instanceof BreadthValue)) {
            return null;
        }
        return new MinMaxValue((BreadthValue)min, (BreadthValue)max);
    }

    private static TemplateValue parseRepeat(String str, float emValue, float remValue, Map<String, List<Integer>> lineNumbersPerName, int currentLine) {
        ArrayList<GridValue> repeatList = new ArrayList<GridValue>();
        int repeatTypeEndIndex = str.indexOf(44);
        if (repeatTypeEndIndex < 0) {
            return null;
        }
        String repeatType = str.substring("repeat".length() + 1, repeatTypeEndIndex).trim();
        Integer repeatCount = CssDimensionParsingUtils.parseInteger(repeatType);
        List<String> repeatStr = CssUtils.extractShorthandProperties(str.substring(repeatTypeEndIndex + 1, str.length() - 1)).get(0);
        HashMap<String, List<Integer>> repeatLineNumbersPerName = new HashMap<String, List<Integer>>();
        for (String strValue : repeatStr) {
            TemplateValue value = GridApplierUtil.parseTemplateValue(strValue, emValue, remValue, repeatLineNumbersPerName, currentLine);
            if (!(value instanceof GridValue)) continue;
            repeatList.add((GridValue)value);
            ++currentLine;
        }
        if (repeatCount != null && repeatCount > 1) {
            for (List repeatLineNumbers : repeatLineNumbersPerName.values()) {
                ArrayList<Integer> extraLineNumbers = new ArrayList<Integer>();
                for (int i = 1; i < repeatCount; ++i) {
                    for (Integer lineNumber : repeatLineNumbers) {
                        int extraLineNumber = lineNumber + repeatList.size() * i;
                        if (extraLineNumbers.contains(extraLineNumber)) continue;
                        extraLineNumbers.add(extraLineNumber);
                    }
                }
                repeatLineNumbers.removeAll(extraLineNumbers);
                repeatLineNumbers.addAll(extraLineNumbers);
            }
        }
        MapUtil.merge(lineNumbersPerName, repeatLineNumbersPerName, (dest, source) -> {
            dest.removeAll((Collection<?>)source);
            dest.addAll(source);
            return dest;
        });
        if (repeatCount != null) {
            return new FixedRepeatValue(repeatCount, repeatList);
        }
        if ("auto-fill".equals(repeatType)) {
            if (!lineNumbersPerName.isEmpty()) {
                LOGGER.warn("Line names are not supported with auto-repeat as a track-size");
            }
            return new AutoRepeatValue(false, repeatList);
        }
        if ("auto-fit".equals(repeatType)) {
            if (!lineNumbersPerName.isEmpty()) {
                LOGGER.warn("Line names are not supported with auto-repeat as a track-size");
            }
            return new AutoRepeatValue(true, repeatList);
        }
        return null;
    }

    private static void applyGridArea(Map<String, String> cssProps, IPropertyContainer element) {
        if (cssProps.get("grid-area") == null) {
            return;
        }
        String gridArea = cssProps.get("grid-area");
        String[] gridAreaParts = gridArea.split("/");
        for (int i = 0; i < gridAreaParts.length; ++i) {
            String part = gridAreaParts[i].trim();
            if ("auto".equals(part)) {
                element.deleteOwnProperty(propsMap.get(i));
                continue;
            }
            GridApplierUtil.applyGridItemPlacement(part, element, propsMap.get(i), spansMap.get(i));
        }
    }

    private static void applyGridItemPlacement(String value, IPropertyContainer element, int property, int spanProperty) {
        if (value == null) {
            return;
        }
        Integer intValue = CssDimensionParsingUtils.parseInteger(value);
        if (intValue != null) {
            element.setProperty(property, intValue);
            return;
        }
        Matcher matcher = SPAN_PLACEMENT.matcher(value.trim());
        if (matcher.matches()) {
            Integer spanValue = CssDimensionParsingUtils.parseInteger(matcher.group(1));
            if (spanValue != null) {
                element.setProperty(spanProperty, spanValue);
            } else {
                element.setProperty(spanProperty, matcher.group(1).trim());
            }
            return;
        }
        element.setProperty(property, value.trim());
    }

    private static NamedAreas parseGridTemplateAreas(String templateAreas) {
        NamedAreas res = new NamedAreas();
        String[] rows = templateAreas.split("[\\\"|']");
        int rowIdx = 0;
        for (String row : rows) {
            String[] names;
            String rowTrimmed = row.trim();
            if (rowTrimmed.isEmpty()) continue;
            ++rowIdx;
            int columnIdx = 0;
            for (String name : names = rowTrimmed.split("\\s+")) {
                if (name.isEmpty()) continue;
                res.addName(name, rowIdx, ++columnIdx);
            }
        }
        return res;
    }

    static {
        propsMap.put(0, 150);
        propsMap.put(1, 148);
        propsMap.put(2, 149);
        propsMap.put(3, 147);
        spansMap.put(0, 101);
        spansMap.put(1, 9);
        spansMap.put(2, 101);
        spansMap.put(3, 9);
    }

    private static final class Placement {
        private int rowStart;
        private int rowEnd;
        private int columnStart;
        private int columnEnd;

        public Placement(int rowStart, int rowEnd, int columnStart, int columnEnd) {
            this.rowStart = rowStart;
            this.rowEnd = rowEnd;
            this.columnStart = columnStart;
            this.columnEnd = columnEnd;
        }

        public void increaseSpansTill(int row, int column) {
            boolean valid = false;
            if (row == this.rowEnd + 1) {
                valid = column == this.columnStart;
            } else if (column == this.columnEnd + 1) {
                boolean bl = valid = row == this.rowEnd;
            }
            if (!valid) {
                LOGGER.error("grid-template-areas property is invalid. The result is nondeterministic");
                return;
            }
            this.rowEnd = row;
            this.columnEnd = column;
        }

        public int getRowStart() {
            return this.rowStart;
        }

        public int getRowEnd() {
            return this.rowEnd;
        }

        public int getColumnStart() {
            return this.columnStart;
        }

        public int getColumnEnd() {
            return this.columnEnd;
        }
    }

    private static final class NamedAreas {
        private static final String DOT_PLACEHOLDER = ".";
        private static final String AREA_START_SUFFIX = "-start";
        private static final String AREA_END_SUFFIX = "-end";
        private final Map<String, Placement> areas = new HashMap<String, Placement>();
        private int rowsCount = 0;
        private int columnsCount = 0;

        NamedAreas() {
        }

        public void addName(String name, int row, int column) {
            if (DOT_PLACEHOLDER.equals(name) || CssDimensionParsingUtils.parseInteger(name) != null) {
                return;
            }
            Placement placement = this.areas.get(name);
            if (placement == null) {
                this.areas.put(name, new Placement(row, row, column, column));
            } else {
                placement.increaseSpansTill(row, column);
            }
            this.rowsCount = Math.max(this.rowsCount, row);
            this.columnsCount = Math.max(this.columnsCount, column);
        }

        public void setPlaceToElement(String name, IPropertyContainer element) {
            Placement placement = this.areas.get(name);
            if (placement == null) {
                return;
            }
            element.setProperty(150, placement.getRowStart());
            element.setProperty(149, placement.getRowEnd() + 1);
            element.setProperty(148, placement.getColumnStart());
            element.setProperty(147, placement.getColumnEnd() + 1);
        }

        public Map<String, List<Integer>> getNamedRowNumbers() {
            HashMap<String, List<Integer>> namedNumbers = new HashMap<String, List<Integer>>(this.areas.size() * 2);
            for (Map.Entry<String, Placement> area : this.areas.entrySet()) {
                namedNumbers.put(area.getKey() + AREA_START_SUFFIX, new ArrayList<Integer>(Arrays.asList(area.getValue().getRowStart())));
                namedNumbers.put(area.getKey() + AREA_END_SUFFIX, new ArrayList<Integer>(Arrays.asList(area.getValue().getRowEnd() + 1)));
            }
            return namedNumbers;
        }

        public Map<String, List<Integer>> getNamedColumnNumbers() {
            HashMap<String, List<Integer>> namedNumbers = new HashMap<String, List<Integer>>();
            for (Map.Entry<String, Placement> area : this.areas.entrySet()) {
                namedNumbers.put(area.getKey() + AREA_START_SUFFIX, new ArrayList<Integer>(Arrays.asList(area.getValue().getColumnStart())));
                namedNumbers.put(area.getKey() + AREA_END_SUFFIX, new ArrayList<Integer>(Arrays.asList(area.getValue().getColumnEnd() + 1)));
            }
            return namedNumbers;
        }

        public int getRowsCount() {
            return this.rowsCount;
        }

        public int getColumnsCount() {
            return this.columnsCount;
        }
    }
}

