/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.AlternateDescriptionResolver;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHelper.class);

    private LinkHelper() {
    }

    public static void applyLinkAnnotation(IPropertyContainer container, String url, ProcessorContext context, IElementNode element) {
        if (container != null) {
            PdfLinkAnnotation linkAnnotation;
            if (url.startsWith("#")) {
                String id = url.substring(1);
                linkAnnotation = context.getLinkContext().getLinkAnnotation(id);
                if (linkAnnotation == null) {
                    linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createGoTo(id)).setFlags(4);
                    context.getLinkContext().addLinkAnnotation(id, linkAnnotation);
                }
            } else {
                linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createURI(url)).setFlags(4);
            }
            if (container instanceof IAccessibleElement) {
                context.getDIContainer().getInstance(AlternateDescriptionResolver.class).resolve((IAccessibleElement)((Object)container), element);
                String altDescription = ((IAccessibleElement)((Object)container)).getAccessibilityProperties().getAlternateDescription();
                if (altDescription != null) {
                    linkAnnotation.setContents(altDescription);
                }
            }
            linkAnnotation.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
            container.setProperty(88, linkAnnotation);
            if (container instanceof ILeafElement && container instanceof IAccessibleElement) {
                ((IAccessibleElement)((Object)container)).getAccessibilityProperties().setRole("Link");
            }
        }
    }

    public static void createDestination(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        String id = element.getAttribute("id");
        if (id == null) {
            return;
        }
        IPropertyContainer propertyContainer = LinkHelper.getPropertyContainer(tagWorker);
        if (context.getLinkContext().isUsedLinkDestination(id)) {
            if (propertyContainer == null) {
                String tagWorkerClassName = tagWorker != null ? tagWorker.getClass().getName() : "null";
                LOGGER.warn(MessageFormatUtil.format("The anchor link was not handled. Could not create a destination for element \"{0}\" with ID \"{1}\", which is processed by \"{2}\" tag worker class.", element.name(), id, tagWorkerClassName));
                return;
            }
            PdfLinkAnnotation linkAnnotation = context.getLinkContext().getLinkAnnotation(id);
            if (linkAnnotation == null) {
                linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createGoTo(id)).setFlags(4);
                context.getLinkContext().addLinkAnnotation(id, linkAnnotation);
            }
            propertyContainer.setProperty(17, new Tuple2<String, PdfDictionary>(id, linkAnnotation.getAction()));
        }
        if (propertyContainer != null) {
            propertyContainer.setProperty(126, id);
        }
    }

    private static IPropertyContainer getPropertyContainer(ITagWorker tagWorker) {
        if (tagWorker != null) {
            if (tagWorker instanceof SpanTagWorker) {
                List<IPropertyContainer> spanElements = ((SpanTagWorker)tagWorker).getAllElements();
                if (!spanElements.isEmpty()) {
                    return spanElements.get(0);
                }
            } else {
                return tagWorker.getElementResult();
            }
        }
        return null;
    }
}

