/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.AlternateDescriptionResolver;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.properties.ObjectFit;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.svg.element.SvgImage;
import com.itextpdf.svg.xobject.SvgImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgTagWorker
implements ITagWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImgTagWorker.class);
    private Image image;
    private String display;

    public ImgTagWorker(IElementNode element, ProcessorContext context) {
        String src = element.getAttribute("src");
        PdfXObject imageXObject = context.getResourceResolver().retrieveImage(src);
        if (imageXObject != null) {
            if (imageXObject instanceof PdfImageXObject) {
                this.image = new HtmlImage((PdfImageXObject)imageXObject);
            } else if (imageXObject instanceof SvgImageXObject) {
                SvgImageXObject svgImageXObject = (SvgImageXObject)imageXObject;
                this.image = new SvgImage(svgImageXObject);
                svgImageXObject.setIsCreatedByImg(true);
            } else if (imageXObject instanceof PdfFormXObject) {
                this.image = new HtmlImage((PdfFormXObject)imageXObject);
            } else {
                throw new IllegalStateException();
            }
        }
        String string = this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
        if (element.getStyles() != null && "absolute".equals(element.getStyles().get("position"))) {
            this.display = "block";
        }
        if (this.image != null) {
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.image, element);
            context.getDIContainer().getInstance(AlternateDescriptionResolver.class).resolve(this.image, element);
            String objectFitValue = element.getStyles() != null ? element.getStyles().get("object-fit") : null;
            this.image.setObjectFit(this.getObjectFitValue(objectFitValue));
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.image;
    }

    String getDisplay() {
        return this.display;
    }

    private ObjectFit getObjectFitValue(String objectFitValue) {
        if (objectFitValue == null) {
            return ObjectFit.FILL;
        }
        switch (objectFitValue) {
            case "contain": {
                return ObjectFit.CONTAIN;
            }
            case "cover": {
                return ObjectFit.COVER;
            }
            case "scale-down": {
                return ObjectFit.SCALE_DOWN;
            }
            case "none": {
                return ObjectFit.NONE;
            }
            case "fill": {
                return ObjectFit.FILL;
            }
        }
        LOGGER.warn(MessageFormatUtil.format("Unexpected value of object-fit property: {0}. Will be processed as default", objectFitValue));
        return ObjectFit.FILL;
    }

    private static class HtmlImage
    extends Image {
        private static final double PX_TO_PT_MULTIPLIER = 0.75;
        private double dimensionMultiplier = 1.0;

        public HtmlImage(PdfImageXObject xObject) {
            super(xObject);
            this.dimensionMultiplier = 0.75;
        }

        public HtmlImage(PdfFormXObject xObject) {
            super(xObject);
        }

        @Override
        public float getImageWidth() {
            return (float)((double)this.xObject.getWidth() * this.dimensionMultiplier);
        }

        @Override
        public float getImageHeight() {
            return (float)((double)this.xObject.getHeight() * this.dimensionMultiplier);
        }
    }
}

