/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.DivTagWorker;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class BodyTagWorker
extends DivTagWorker {
    private ITagWorker parentTagWorker;
    private String lang;

    public BodyTagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
        this.parentTagWorker = context.getState().empty() ? null : context.getState().top();
        PdfDocument pdfDocument = context.getPdfDocument();
        if (pdfDocument != null) {
            this.lang = element.getAttribute("lang");
            if (this.lang != null) {
                pdfDocument.getCatalog().setLang(new PdfString(this.lang, "UnicodeBig"));
            }
        } else {
            this.lang = element.getLang();
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (this.parentTagWorker == null) {
            super.processEnd(element, context);
            if (context.getPdfDocument() == null) {
                for (IElement child : ((Div)super.getElementResult()).getChildren()) {
                    if (!(child instanceof IAccessibleElement)) continue;
                    AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)((Object)child), this.lang);
                }
            }
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        if (this.parentTagWorker == null) {
            return super.processContent(content, context);
        }
        return this.parentTagWorker.processContent(content, context);
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        if (this.parentTagWorker == null) {
            return super.processTagChild(childTagWorker, context);
        }
        return this.parentTagWorker.processTagChild(childTagWorker, context);
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.parentTagWorker == null ? super.getElementResult() : this.parentTagWorker.getElementResult();
    }
}

