/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.impl.layout.PageTargetCountElement;
import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.html2pdf.html.HtmlUtils;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.renderer.TextRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageTargetCountRenderer
extends TextRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageTargetCountRenderer.class);
    private static final String UNDEFINED_VALUE = "0";
    private final String target;
    private final CounterDigitsGlyphStyle digitsGlyphStyle;

    PageTargetCountRenderer(PageTargetCountElement textElement) {
        super(textElement);
        this.digitsGlyphStyle = textElement.getDigitsGlyphStyle();
        this.target = textElement.getTarget();
    }

    protected PageTargetCountRenderer(TextRenderer other) {
        super(other);
        this.digitsGlyphStyle = ((PageTargetCountRenderer)other).digitsGlyphStyle;
        this.target = ((PageTargetCountRenderer)other).target;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        String previousText = this.getText().toString();
        Integer page = TargetCounterHandler.getPageByID(this, this.target);
        if (page == null) {
            this.setText(UNDEFINED_VALUE);
        } else {
            this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, page));
        }
        LayoutResult result = super.layout(layoutContext);
        this.setText(previousText);
        return result;
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (!TargetCounterHandler.isValueDefinedForThisId(this, this.target)) {
            LOGGER.warn(MessageFormatUtil.format("Cannot resolve target-counter value with given target \"{0}\"", this.target));
        }
        super.draw(drawContext);
    }

    @Override
    public IRenderer getNextRenderer() {
        if (PageTargetCountRenderer.class != this.getClass()) {
            Logger logger = LoggerFactory.getLogger(PageTargetCountRenderer.class);
            logger.error(MessageFormatUtil.format("If a renderer overflows, iText uses this method to create another renderer for the overflow part. So if one wants to extend the renderer, one should override this method: otherwise the default method will be used and thus the default rather than the custom renderer will be created.", new Object[0]));
        }
        return new PageTargetCountRenderer((PageTargetCountElement)this.modelElement);
    }

    @Override
    protected TextRenderer createCopy(GlyphLine gl, PdfFont font) {
        if (PageTargetCountRenderer.class != this.getClass()) {
            Logger logger = LoggerFactory.getLogger(PageTargetCountRenderer.class);
            logger.error(MessageFormatUtil.format("While processing an instance of TextRenderer, iText uses createCopy() to create glyph lines of specific fonts, which represent its parts. So if one extends TextRenderer, one should override createCopy, otherwise if FontSelector related logic is triggered, copies of this TextRenderer will have the default behavior rather than the custom one.", new Object[0]));
        }
        PageTargetCountRenderer copy = new PageTargetCountRenderer(this);
        copy.setProcessedGlyphLineAndFont(gl, font);
        return copy;
    }

    @Override
    protected boolean resolveFonts(List<IRenderer> addTo) {
        ArrayList<IRenderer> dummyList = new ArrayList<IRenderer>();
        super.resolveFonts(dummyList);
        this.setProperty(20, ((IRenderer)dummyList.get(0)).getProperty(20));
        addTo.add(this);
        return true;
    }
}

