/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.util;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;

public final class FontSizeUtil {
    private FontSizeUtil() {
    }

    public static float approximateFontSizeToFitSingleLine(PdfFont localFont, Rectangle bBox, String value, float minValue, float borderWidth) {
        float height = bBox.getHeight() - borderWidth * 2.0f;
        int[] fontBbox = localFont.getFontProgram().getFontMetrics().getBbox();
        float fs = FontProgram.convertGlyphSpaceToTextSpace(height / (float)(fontBbox[2] - fontBbox[1]));
        float baseWidth = localFont.getWidth(value, 1.0f);
        if (baseWidth != 0.0f) {
            float absMaxPadding;
            float relativePaddingForSmallSizes;
            float availableWidth = Math.max(bBox.getWidth() - borderWidth * 2.0f, 0.0f);
            availableWidth = availableWidth * (relativePaddingForSmallSizes = 0.15f) < (absMaxPadding = 4.0f) ? (availableWidth -= availableWidth * relativePaddingForSmallSizes * 2.0f) : (availableWidth -= absMaxPadding * 2.0f);
            fs = Math.min(fs, availableWidth / baseWidth);
        }
        return Math.max(fs, minValue);
    }
}

