/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.ChoiceFormFieldBuilder;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.element.ListBoxField;
import com.itextpdf.forms.form.element.SelectFieldItem;
import com.itextpdf.forms.form.renderer.AbstractSelectFieldRenderer;
import com.itextpdf.forms.util.BorderStyleUtil;
import com.itextpdf.forms.util.FormFieldRendererUtil;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFieldListBoxRenderer
extends AbstractSelectFieldRenderer {
    public SelectFieldListBoxRenderer(AbstractSelectField modelElement) {
        super(modelElement);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new SelectFieldListBoxRenderer((AbstractSelectField)this.modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        IRenderer firstSelectedOption;
        List<IRenderer> selectedOptions;
        IRenderer optionsContainer;
        LayoutResult layoutResult = super.layout(layoutContext);
        IRenderer iRenderer = optionsContainer = this.childRenderers.size() == 1 ? (IRenderer)this.childRenderers.get(0) : null;
        if (!this.isFlatten() || layoutResult.getStatus() != 1 || optionsContainer == null || optionsContainer.getOccupiedArea() == null) {
            return layoutResult;
        }
        if (SelectFieldListBoxRenderer.isOverflowProperty(OverflowPropertyValue.HIDDEN, this, 104) && !(selectedOptions = this.getSelectedOptions(this)).isEmpty() && (firstSelectedOption = selectedOptions.get(0)).getOccupiedArea() != null) {
            Rectangle borderAreaBBox = this.getBorderAreaBBox();
            Rectangle optionBBox = firstSelectedOption.getOccupiedArea().getBBox().clone();
            if (firstSelectedOption instanceof AbstractRenderer) {
                ((AbstractRenderer)firstSelectedOption).applyMargins(optionBBox, false);
            }
            if (optionBBox.getHeight() < borderAreaBBox.getHeight()) {
                float borderAreaBBoxBottom;
                float selectedBottom = optionBBox.getBottom();
                if (selectedBottom < (borderAreaBBoxBottom = borderAreaBBox.getBottom())) {
                    optionsContainer.move(0.0f, borderAreaBBoxBottom - selectedBottom);
                }
            } else {
                optionsContainer.move(0.0f, borderAreaBBox.getTop() - optionBBox.getTop());
            }
        }
        return layoutResult;
    }

    @Override
    protected boolean allowLastYLineRecursiveExtraction() {
        return false;
    }

    @Override
    protected IRenderer createFlatRenderer() {
        IRenderer rendererSubTree;
        AccessibilityProperties properties;
        AbstractSelectField selectField = (AbstractSelectField)this.modelElement;
        List<SelectFieldItem> options = selectField.getOptions();
        Div optionsContainer = new Div();
        int topIndex = this.getProperty(0x200010, 0);
        List<SelectFieldItem> visibleOptions = topIndex > 0 ? options.subList(topIndex, options.size()) : options;
        for (SelectFieldItem option : visibleOptions) {
            optionsContainer.add(option.getElement());
        }
        for (IElement child : optionsContainer.getChildren()) {
            if (!(child instanceof IAccessibleElement)) continue;
            ((IAccessibleElement)((Object)child)).getAccessibilityProperties().setRole("Lbl");
        }
        String lang = this.getLang();
        if (lang != null && (properties = optionsContainer.getAccessibilityProperties()).getLanguage() == null) {
            properties.setLanguage(lang);
        }
        if (optionsContainer.getChildren().isEmpty()) {
            Paragraph pStub = (Paragraph)new Paragraph("\u00a0").setMargin(0.0f);
            pStub.getAccessibilityProperties().setRole("Lbl");
            pStub.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
            pStub.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
            pStub.setProperty(0x200009, false);
            optionsContainer.add(pStub);
            rendererSubTree = optionsContainer.createRendererSubTree();
        } else {
            rendererSubTree = optionsContainer.createRendererSubTree();
            List<IRenderer> selectedOptions = this.getSelectedOptions(rendererSubTree);
            for (IRenderer selectedOption : selectedOptions) {
                this.applySelectedStyle(selectedOption);
            }
        }
        return rendererSubTree;
    }

    @Override
    protected float getFinalSelectFieldHeight(float availableHeight, float actualHeight, boolean isClippedHeight) {
        float calculatedHeight;
        Float height = this.retrieveHeight();
        if (height == null) {
            Float minHeight;
            calculatedHeight = this.getCalculatedHeight(this);
            Float maxHeight = this.retrieveMaxHeight();
            if (maxHeight != null && maxHeight.floatValue() < calculatedHeight) {
                calculatedHeight = maxHeight.floatValue();
            }
            if ((minHeight = this.retrieveMinHeight()) != null && minHeight.floatValue() > calculatedHeight) {
                calculatedHeight = minHeight.floatValue();
            }
        } else {
            calculatedHeight = height.floatValue();
        }
        return super.getFinalSelectFieldHeight(availableHeight, calculatedHeight, isClippedHeight);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        TransparentColor color;
        PdfFont font = this.getResolvedFont(drawContext.getDocument());
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(SelectFieldListBoxRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedArea().getBBox().clone();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        this.applyMargins(area, false);
        Map<Integer, Object> properties = FormFieldRendererUtil.removeProperties(this.modelElement);
        this.modelElement.setProperty(91, this.getProperty(91));
        this.modelElement.setProperty(123, this.getProperty(123));
        ListBoxField lbModelElement = (ListBoxField)this.modelElement;
        List<String> selectedOptions = lbModelElement.getSelectedStrings();
        ChoiceFormFieldBuilder builder = (ChoiceFormFieldBuilder)((ChoiceFormFieldBuilder)((ChoiceFormFieldBuilder)new ChoiceFormFieldBuilder(doc, this.getModelId()).setConformance(this.getConformance(doc))).setFont(font)).setWidgetRectangle(area);
        this.setupBuilderValues(builder, lbModelElement);
        PdfChoiceFormField choiceField = builder.createList();
        choiceField.disableFieldRegeneration();
        this.applyAccessibilityProperties(choiceField, drawContext.getDocument());
        choiceField.setFontSize(fontSize.getValue());
        choiceField.setMultiSelect(this.isMultiple());
        choiceField.setListSelected(selectedOptions.toArray(new String[selectedOptions.size()]));
        Integer topIndex = (Integer)this.modelElement.getOwnProperty(0x200010);
        if (topIndex != null) {
            choiceField.setTopIndex(topIndex);
        }
        if ((color = this.getPropertyAsTransparentColor(21)) != null) {
            choiceField.setColor(color.getColor());
        }
        choiceField.setJustification((TextAlignment)((Object)this.getProperty(70)));
        BorderStyleUtil.applyBorderProperty(this, choiceField.getFirstFormAnnotation());
        Background background = (Background)this.getProperty(6);
        if (background != null) {
            choiceField.getFirstFormAnnotation().setBackgroundColor(background.getColor());
        }
        choiceField.getFirstFormAnnotation().setFormFieldElement(lbModelElement);
        choiceField.enableFieldRegeneration();
        PdfFormCreator.getAcroForm(doc, true).addField(choiceField, page);
        FormFieldRendererUtil.reapplyProperties(this.modelElement, properties);
    }

    private float getCalculatedHeight(IRenderer flatRenderer) {
        Integer sizeProp = (Integer)this.getProperty(0x200002);
        int size = sizeProp == null || sizeProp <= 0 ? 4 : sizeProp;
        float maxOptionActualHeight = this.getMaxOptionActualHeight(flatRenderer);
        if (maxOptionActualHeight == Float.MIN_VALUE) {
            UnitValue fontSize = (UnitValue)flatRenderer.getProperty(24);
            maxOptionActualHeight = fontSize != null && fontSize.isPointValue() ? fontSize.getValue() * 1.2f : 0.0f;
        }
        return (float)size * maxOptionActualHeight;
    }

    private float getMaxOptionActualHeight(IRenderer flatRenderer) {
        float maxActualHeight = Float.MIN_VALUE;
        for (IRenderer child : flatRenderer.getChildRenderers()) {
            if (SelectFieldListBoxRenderer.isOptionRenderer(child)) {
                float childHeight;
                if (child instanceof AbstractRenderer) {
                    AbstractRenderer abstractChild = (AbstractRenderer)child;
                    childHeight = abstractChild.applyMargins(abstractChild.getOccupiedAreaBBox(), false).getHeight();
                } else {
                    childHeight = child.getOccupiedArea().getBBox().getHeight();
                }
                if (!(childHeight > maxActualHeight)) continue;
                maxActualHeight = childHeight;
                continue;
            }
            float maxNestedHeight = this.getMaxOptionActualHeight(child);
            if (!(maxNestedHeight > maxActualHeight)) continue;
            maxActualHeight = maxNestedHeight;
        }
        return maxActualHeight;
    }

    private List<IRenderer> getSelectedOptions(IRenderer rendererSubTree) {
        ArrayList<IRenderer> selectedOptions = new ArrayList<IRenderer>();
        List<IRenderer> optionsWhichMarkedSelected = this.getOptionsMarkedSelected(rendererSubTree);
        if (!optionsWhichMarkedSelected.isEmpty()) {
            if (this.isMultiple()) {
                selectedOptions.addAll(optionsWhichMarkedSelected);
            } else {
                selectedOptions.add(optionsWhichMarkedSelected.get(optionsWhichMarkedSelected.size() - 1));
            }
        }
        return selectedOptions;
    }

    private boolean isMultiple() {
        Boolean propertyAsBoolean = this.getPropertyAsBoolean(0x200008);
        return propertyAsBoolean != null && propertyAsBoolean != false;
    }

    private void applySelectedStyle(IRenderer selectedOption) {
        RenderingMode mode = (RenderingMode)((Object)this.getProperty(123));
        if (RenderingMode.HTML_MODE.equals((Object)mode) && this.isFlatten() && selectedOption.getProperty(6) == null) {
            selectedOption.setProperty(6, new Background(new DeviceRgb(206, 206, 206)));
        } else {
            selectedOption.setProperty(6, new Background(new DeviceRgb(169, 204, 225)));
        }
        this.setFontColorRecursively(selectedOption);
    }

    private void setFontColorRecursively(IRenderer selectedOption) {
        selectedOption.setProperty(21, new TransparentColor(ColorConstants.BLACK));
        for (IRenderer renderer : selectedOption.getChildRenderers()) {
            this.setFontColorRecursively(renderer);
        }
    }
}

