/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.commons.datastructures.NullableContainer;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.FormsMetaInfoStaticContainer;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.fields.borders.FormBorderFactory;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.forms.fields.properties.SignedAppearanceText;
import com.itextpdf.forms.form.element.Button;
import com.itextpdf.forms.form.element.CheckBox;
import com.itextpdf.forms.form.element.ComboBoxField;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.element.InputField;
import com.itextpdf.forms.form.element.ListBoxField;
import com.itextpdf.forms.form.element.Radio;
import com.itextpdf.forms.form.element.SelectFieldItem;
import com.itextpdf.forms.form.element.SignatureFieldAppearance;
import com.itextpdf.forms.form.element.TextArea;
import com.itextpdf.forms.form.renderer.checkboximpl.PdfCheckBoxRenderingStrategy;
import com.itextpdf.forms.util.FontSizeUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFormAnnotation
extends AbstractPdfFormField {
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int VISIBLE = 4;
    public static final String OFF_STATE_VALUE = "Off";
    public static final String ON_STATE_VALUE = "Yes";
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfFormAnnotation.class);
    private static final String LINE_ENDINGS_REGEXP = "\\r\\n|\\r|\\n";
    private static final float EPS = 1.0E-4f;
    protected float borderWidth = 1.0f;
    protected Color backgroundColor;
    protected Color borderColor;
    private IFormField formFieldElement;

    protected PdfFormAnnotation(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        this((PdfDictionary)widget.makeIndirect(pdfDocument).getPdfObject());
    }

    protected PdfFormAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfFormAnnotation makeFormAnnotation(PdfObject pdfObject, PdfDocument document) {
        if (!pdfObject.isDictionary()) {
            return null;
        }
        PdfDictionary dictionary = (PdfDictionary)pdfObject;
        PdfName subType = dictionary.getAsName(PdfName.Subtype);
        if (!PdfName.Widget.equals(subType)) {
            return null;
        }
        PdfFormAnnotation field = PdfFormCreator.createFormAnnotation((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation(dictionary), document);
        field.makeIndirect(document);
        if (document != null) {
            field.pdfConformance = document.getConformance();
        }
        return field;
    }

    public PdfWidgetAnnotation getWidget() {
        PdfName subType = this.getPdfObject().getAsName(PdfName.Subtype);
        if (subType != null && subType.equals(PdfName.Widget)) {
            return (PdfWidgetAnnotation)PdfAnnotation.makeAnnotation(this.getPdfObject());
        }
        assert ("You are not an annotation then" == null);
        return null;
    }

    @Override
    public PdfString getDefaultAppearance() {
        return this.getPdfObject().getAsString(PdfName.DA);
    }

    @Override
    public boolean regenerateField() {
        if (this.parent != null && this.parent.isFieldRegenerationEnabled()) {
            this.parent.updateDefaultAppearance();
        }
        return this.regenerateWidget();
    }

    @Override
    public String[] getAppearanceStates() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PdfDictionary dic = this.getPdfObject();
        if ((dic = dic.getAsDictionary(PdfName.AP)) != null && (dic = dic.getAsDictionary(PdfName.N)) != null) {
            for (PdfName state : dic.keySet()) {
                names.add(state.getValue());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    void retrieveStyles() {
        super.retrieveStyles();
        PdfDictionary appearanceCharacteristics = this.getPdfObject().getAsDictionary(PdfName.MK);
        if (appearanceCharacteristics != null) {
            this.backgroundColor = PdfFormAnnotation.appearancePropToColor(appearanceCharacteristics, PdfName.BG);
            Color extractedBorderColor = PdfFormAnnotation.appearancePropToColor(appearanceCharacteristics, PdfName.BC);
            if (extractedBorderColor != null) {
                this.borderColor = extractedBorderColor;
            }
            if (this.parent != null) {
                this.parent.text = PdfFormAnnotation.appearancePropToCaption(appearanceCharacteristics);
            }
        }
    }

    public PdfFormAnnotation setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        PdfWidgetAnnotation kid = this.getWidget();
        PdfDictionary mk = kid.getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        if (backgroundColor == null) {
            mk.remove(PdfName.BG);
        } else {
            mk.put(PdfName.BG, new PdfArray(backgroundColor.getColorValue()));
        }
        kid.setAppearanceCharacteristics(mk);
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setCaption(String caption) {
        return this.setCaption(caption, true);
    }

    public PdfFormAnnotation setCaption(String caption, boolean regenerateField) {
        PdfWidgetAnnotation kid;
        PdfDictionary mk;
        if (this.parent != null) {
            this.parent.text = caption;
        }
        if ((mk = (kid = this.getWidget()).getAppearanceCharacteristics()) == null) {
            mk = new PdfDictionary();
        }
        if (caption == null) {
            mk.remove(PdfName.CA);
        } else {
            mk.put(PdfName.CA, new PdfString(caption));
        }
        kid.setAppearanceCharacteristics(mk);
        if (regenerateField) {
            this.regenerateField();
        }
        return this;
    }

    public int getRotation() {
        PdfDictionary mk = this.getWidget().getAppearanceCharacteristics();
        return mk == null || mk.getAsInt(PdfName.R) == null ? 0 : mk.getAsInt(PdfName.R);
    }

    public PdfFormAnnotation setRotation(int degRotation) {
        PdfDictionary mk;
        if (degRotation % 90 != 0) {
            throw new IllegalArgumentException("degRotation.must.be.a.multiple.of.90");
        }
        if ((degRotation %= 360) < 0) {
            degRotation += 360;
        }
        if ((mk = this.getWidget().getAppearanceCharacteristics()) == null) {
            mk = new PdfDictionary();
            this.put(PdfName.MK, mk);
        }
        mk.put(PdfName.R, new PdfNumber(degRotation));
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setAction(PdfAction action) {
        PdfWidgetAnnotation widget = this.getWidget();
        if (widget != null) {
            widget.setAction(action);
        }
        return this;
    }

    public PdfFormAnnotation setVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                this.put(PdfName.F, new PdfNumber(6));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.put(PdfName.F, new PdfNumber(36));
                break;
            }
            default: {
                this.put(PdfName.F, new PdfNumber(4));
            }
        }
        return this;
    }

    public float getBorderWidth() {
        PdfNumber w;
        PdfDictionary bs = this.getWidget().getBorderStyle();
        if (bs != null && (w = bs.getAsNumber(PdfName.W)) != null) {
            this.borderWidth = w.floatValue();
        }
        return this.borderWidth;
    }

    public PdfFormAnnotation setBorderWidth(float borderWidth) {
        PdfDictionary bs = this.getWidget().getBorderStyle();
        if (bs == null) {
            bs = new PdfDictionary();
            this.put(PdfName.BS, bs);
        }
        bs.put(PdfName.W, new PdfNumber(borderWidth));
        this.borderWidth = borderWidth;
        this.regenerateField();
        return this;
    }

    public Border getBorder() {
        float borderWidth = this.getBorderWidth();
        Border border = FormBorderFactory.getBorder(this.getWidget().getBorderStyle(), borderWidth, this.borderColor, this.backgroundColor);
        if (border == null && borderWidth > 0.0f && this.borderColor != null) {
            border = new SolidBorder(this.borderColor, borderWidth);
        }
        return border;
    }

    public PdfFormAnnotation setBorderStyle(PdfDictionary style) {
        this.getWidget().setBorderStyle(style);
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setBorderColor(Color color) {
        this.borderColor = color;
        PdfWidgetAnnotation kid = this.getWidget();
        PdfDictionary mk = kid.getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        if (this.borderColor == null) {
            mk.remove(PdfName.BC);
        } else {
            mk.put(PdfName.BC, new PdfArray(this.borderColor.getColorValue()));
        }
        kid.setAppearanceCharacteristics(mk);
        this.regenerateField();
        return this;
    }

    public PdfFormAnnotation setPage(int pageNum) {
        PdfWidgetAnnotation widget = this.getWidget();
        if (widget != null) {
            widget.setPage(this.getDocument().getPage(pageNum));
        }
        return this;
    }

    public PdfFormAnnotation setFormFieldElement(IFormField element) {
        this.formFieldElement = element;
        this.regenerateWidget();
        return this;
    }

    public PdfFormAnnotation setAppearance(PdfName appearanceType, String appearanceState, PdfStream appearanceStream) {
        PdfDictionary dic = this.getPdfObject();
        PdfDictionary ap = dic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            PdfDictionary appearanceDictionary = ap.getAsDictionary(appearanceType);
            if (appearanceDictionary == null) {
                ap.put(appearanceType, appearanceStream);
            } else {
                appearanceDictionary.put(new PdfName(appearanceState), appearanceStream);
            }
        }
        return this;
    }

    public PdfFormAnnotation setCheckBoxAppearanceOnStateName(String onStateName) {
        if (this.isCheckBox() && onStateName != null && !onStateName.isEmpty() && !OFF_STATE_VALUE.equals(onStateName)) {
            this.drawCheckBoxAndSaveAppearance(onStateName);
            this.getWidget().setAppearanceState(new PdfName(onStateName.equals(this.parent.getValueAsString()) ? onStateName : OFF_STATE_VALUE));
        }
        return this;
    }

    public PdfFormAnnotation setAlternativeDescription(String alternativeDescription) {
        this.put(PdfName.Contents, new PdfString(alternativeDescription));
        return this;
    }

    public PdfString getAlternativeDescription() {
        return this.getPdfObject().getAsString(PdfName.Contents);
    }

    protected Rectangle getRect(PdfDictionary field) {
        PdfArray rect = field.getAsArray(PdfName.Rect);
        return rect == null ? null : rect.toRectangle();
    }

    protected void drawBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        PdfArray matrix;
        canvas.saveState();
        float borderWidth = this.getBorderWidth();
        PdfDictionary bs = this.getWidget().getBorderStyle();
        if (borderWidth < 0.0f) {
            borderWidth = 0.0f;
        }
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).rectangle(0.0, 0.0, width, height).fill();
        }
        if (borderWidth > 0.0f && this.borderColor != null) {
            borderWidth = Math.max(1.0f, borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(borderWidth);
            Border border = FormBorderFactory.getBorder(bs, borderWidth, this.borderColor, this.backgroundColor);
            if (border != null) {
                float borderWidthX2 = borderWidth + borderWidth;
                border.draw(canvas, new Rectangle(borderWidth, borderWidth, width - borderWidthX2, height - borderWidthX2));
            } else {
                canvas.rectangle(0.0, 0.0, width, height).stroke();
            }
        }
        if ((matrix = PdfFormAnnotation.getRotationMatrix(this.getRotation(), height, width)) != null) {
            xObject.put(PdfName.Matrix, matrix);
        }
        canvas.restoreState();
    }

    protected void drawPushButtonFieldAndSaveAppearance() {
        Image image;
        float imagePadding;
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        int fieldRotation = this.getRotation();
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rectangle.getHeight(), rectangle.getWidth());
        rectangle = this.applyRotation(fieldRotation, rectangle);
        this.createInputButton();
        this.setModelElementProperties(rectangle);
        float fontSize = this.getFontSize(new PdfArray(rectangle), this.parent.getDisplayValue());
        this.formFieldElement.setProperty(24, UnitValue.createPointValue(fontSize));
        float width = rectangle.getWidth();
        float height = rectangle.getHeight();
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        if (matrix != null) {
            xObject.put(PdfName.Matrix, matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        String caption = this.parent.getDisplayValue();
        if (caption != null && !caption.isEmpty()) {
            ((Button)this.formFieldElement).setSingleLineValue(caption);
        }
        float f = imagePadding = this.borderColor == null ? 0.0f : this.borderWidth;
        if (this.parent.img != null) {
            this.formFieldElement.getChildren().clear();
            image = new Image(new PdfImageXObject(this.parent.img), imagePadding, imagePadding);
            image.setHeight(height - 2.0f * imagePadding);
            image.setWidth(width - 2.0f * imagePadding);
            ((Button)this.formFieldElement).add(image);
        } else if (this.parent.form != null) {
            this.formFieldElement.getChildren().clear();
            image = new Image(this.parent.form, imagePadding, imagePadding);
            image.setHeight(height - 2.0f * imagePadding);
            ((Button)this.formFieldElement).add(image);
        } else {
            xObject.getResources().addFont(this.getDocument(), this.getFont());
        }
        canvas.add(this.formFieldElement);
        PdfDictionary ap = new PdfDictionary();
        PdfStream normalAppearanceStream = (PdfStream)xObject.getPdfObject();
        if (normalAppearanceStream != null) {
            PdfName stateName = this.getPdfObject().getAsName(PdfName.AS);
            if (stateName == null) {
                stateName = new PdfName("push");
            }
            this.getPdfObject().put(PdfName.AS, stateName);
            PdfDictionary normalAppearance = new PdfDictionary();
            normalAppearance.put(stateName, normalAppearanceStream);
            ap.put(PdfName.N, normalAppearance);
            ap.setModified();
        }
        this.put(PdfName.AP, ap);
        canvas.setProperty(108, null);
        canvas.close();
        this.formFieldElement.setInteractive(true);
    }

    protected void drawSignatureFormFieldAndSaveAppearance() {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (PdfFormAnnotation.isFieldInvisible(rectangle)) {
            PdfDictionary appearanceDictionary = new PdfDictionary();
            PdfFormXObject normalAppearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f));
            normalAppearance.makeIndirect(this.getDocument());
            appearanceDictionary.put(PdfName.N, (PdfObject)normalAppearance.getPdfObject());
            appearanceDictionary.setModified();
            this.put(PdfName.AP, appearanceDictionary);
            return;
        }
        PdfPage page = this.getWidget().getPage();
        int pageRotation = page == null ? 0 : page.getRotation();
        int additionalFieldRotation = ((PdfSignatureFormField)this.parent).isPageRotationIgnored() ? 0 : -pageRotation;
        int fieldRotation = this.getRotation() + additionalFieldRotation;
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rectangle.getHeight(), rectangle.getWidth());
        rectangle = this.applyRotation(fieldRotation + pageRotation, rectangle);
        this.createSigField();
        this.setModelElementProperties(rectangle);
        PdfFormXObject normalAppearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
        PdfCanvas normalAppearanceCanvas = new PdfCanvas(normalAppearance, this.getDocument());
        if (matrix != null) {
            normalAppearance.put(PdfName.Matrix, matrix);
        }
        PdfFormXObject topLayerXObject = this.createTopLayer(rectangle.getWidth(), rectangle.getHeight());
        normalAppearance.getResources().addForm(topLayerXObject, new PdfName("FRM"));
        normalAppearanceCanvas.addXObjectAt(topLayerXObject, topLayerXObject.getBBox().getAsNumber(0).floatValue(), topLayerXObject.getBBox().getAsNumber(1).floatValue());
        PdfDictionary appearanceDict = new PdfDictionary();
        PdfStream normalAppearanceStream = (PdfStream)normalAppearance.getPdfObject();
        appearanceDict.put(PdfName.N, normalAppearanceStream);
        appearanceDict.setModified();
        this.put(PdfName.AP, appearanceDict);
    }

    protected void drawRadioButtonAndSaveAppearance(String value) {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        if (!(this.formFieldElement instanceof Radio)) {
            this.formFieldElement = new Radio("");
        }
        boolean wasChecked = Boolean.TRUE.equals(this.formFieldElement.getProperty(0x200007));
        this.setModelElementProperties(this.getRect(this.getPdfObject()));
        ((Radio)this.formFieldElement).setChecked(false);
        PdfFormXObject xObjectOff = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
        Canvas canvasOff = new Canvas(xObjectOff, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvasOff);
        canvasOff.add(this.formFieldElement);
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(OFF_STATE_VALUE), (PdfObject)xObjectOff.getPdfObject());
        if (value != null && !value.isEmpty() && !OFF_STATE_VALUE.equals(value)) {
            ((Radio)this.formFieldElement).setChecked(true);
            PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
            Canvas canvas = new Canvas(xObject, this.getDocument());
            PdfFormAnnotation.setMetaInfoToCanvas(canvas);
            canvas.add(this.formFieldElement);
            normalAppearance.put(new PdfName(value), (PdfObject)xObject.getPdfObject());
        }
        ((Radio)this.formFieldElement).setChecked(wasChecked);
        this.getWidget().setNormalAppearance(normalAppearance);
        this.formFieldElement.setInteractive(true);
    }

    protected void drawListFormFieldAndSaveAppearance() {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        int fieldRotation = this.getRotation();
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rectangle.getHeight(), rectangle.getWidth());
        rectangle = this.applyRotation(fieldRotation, rectangle);
        boolean multiselect = this.parent.getFieldFlag(PdfChoiceFormField.FF_MULTI_SELECT);
        if (!(this.formFieldElement instanceof ListBoxField)) {
            this.formFieldElement = new ListBoxField("", 0, multiselect);
        }
        this.formFieldElement.setProperty(0x200008, multiselect);
        ((ListBoxField)this.formFieldElement).setTopIndex(this.parent instanceof PdfChoiceFormField && ((PdfChoiceFormField)this.parent).getTopIndex() != null ? ((PdfChoiceFormField)this.parent).getTopIndex().intValue() : 0);
        PdfArray indices = this.getParent().getAsArray(PdfName.I);
        PdfArray options = this.parent.getOptions();
        String longestOption = "";
        for (int index = 0; index < options.size(); ++index) {
            PdfArray optionArray;
            PdfObject option = options.get(index);
            String exportValue = null;
            String displayValue = null;
            if (option.isString()) {
                exportValue = option.toString();
                if (longestOption.length() < exportValue.length()) {
                    longestOption = exportValue;
                }
            } else if (option.isArray() && (optionArray = (PdfArray)option).size() > 1) {
                exportValue = optionArray.get(0).toString();
                displayValue = optionArray.get(1).toString();
                if (longestOption.length() < displayValue.length()) {
                    longestOption = displayValue;
                }
            }
            if (exportValue == null) continue;
            boolean selected = indices != null && indices.contains(new PdfNumber(index));
            SelectFieldItem existingItem = ((ListBoxField)this.formFieldElement).getOption(exportValue);
            if (existingItem == null) {
                existingItem = displayValue == null ? new SelectFieldItem(exportValue) : new SelectFieldItem(exportValue, displayValue);
                ((ListBoxField)this.formFieldElement).addOption(existingItem);
            }
            existingItem.getElement().setProperty(70, (Object)this.parent.getJustification());
            existingItem.getElement().setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
            existingItem.getElement().setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
            existingItem.getElement().setProperty(0x200009, selected);
            if (selected && (multiselect || index == indices.getAsNumber(indices.size() - 1).intValue())) {
                existingItem.getElement().setProperty(6, new Background(new DeviceRgb(169, 204, 225)));
                continue;
            }
            existingItem.getElement().setProperty(6, null);
        }
        float fontSize = this.getFontSize(new PdfArray(rectangle), longestOption);
        this.formFieldElement.setProperty(24, UnitValue.createPointValue(fontSize));
        this.updateParentFontSize(fontSize);
        this.formFieldElement.setProperty(20, this.getFont());
        if (this.getColor() != null) {
            this.formFieldElement.setProperty(21, new TransparentColor(this.getColor()));
        }
        this.setModelElementProperties(rectangle);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
        if (matrix != null) {
            xObject.put(PdfName.Matrix, matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        canvas.setProperty(82, Boolean.TRUE);
        canvas.getPdfCanvas().beginVariableText().saveState().endPath();
        canvas.add(this.formFieldElement);
        canvas.getPdfCanvas().restoreState().endVariableText();
        this.getWidget().setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        this.formFieldElement.setInteractive(true);
    }

    protected void drawTextFormFieldAndSaveAppearance() {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        int fieldRotation = this.getRotation();
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rectangle.getHeight(), rectangle.getWidth());
        rectangle = this.applyRotation(fieldRotation, rectangle);
        String value = this.parent.getDisplayValue();
        if (!(this.parent.isMultiline() && this.formFieldElement instanceof TextArea || !this.parent.isMultiline() && this.formFieldElement instanceof InputField)) {
            IFormField iFormField = this.formFieldElement = this.parent.isMultiline() ? new TextArea("") : new InputField("");
        }
        if (this.parent.isMultiline()) {
            this.formFieldElement.setProperty(24, UnitValue.createPointValue(this.getFontSize()));
        } else {
            float fontSize = this.getFontSize(new PdfArray(rectangle), this.parent.getValueAsString());
            if (fontSize != 0.0f) {
                this.formFieldElement.setProperty(26, true);
            }
            this.formFieldElement.setProperty(24, UnitValue.createPointValue(fontSize));
            value = value.replaceAll(LINE_ENDINGS_REGEXP, " ");
            ((InputField)this.formFieldElement).setComb(this.isCombTextFormField());
            ((InputField)this.formFieldElement).setMaxLen((this.parent instanceof PdfTextFormField ? (PdfTextFormField)this.parent : PdfFormCreator.createTextFormField(this.parent.getPdfObject())).getMaxLen());
            ((InputField)this.formFieldElement).useAsPassword(this.parent.isPassword());
        }
        this.formFieldElement.setValue(value);
        this.formFieldElement.setProperty(20, this.getFont());
        this.formFieldElement.setProperty(70, (Object)this.parent.getJustification());
        this.formFieldElement.setProperty(0x200004, this.getParentField().isPassword());
        this.formFieldElement.setProperty(137, Boolean.TRUE);
        if (this.getColor() != null) {
            this.formFieldElement.setProperty(21, new TransparentColor(this.getColor()));
        }
        this.setModelElementProperties(rectangle);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight()));
        if (matrix != null) {
            xObject.put(PdfName.Matrix, matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        canvas.setProperty(82, Boolean.TRUE);
        canvas.add(this.formFieldElement);
        this.formFieldElement.setInteractive(true);
        this.getWidget().setNormalAppearance((PdfDictionary)xObject.getPdfObject());
    }

    protected void drawComboBoxAndSaveAppearance() {
        Rectangle rectangle = this.getRect(this.getPdfObject());
        if (rectangle == null) {
            return;
        }
        if (!(this.formFieldElement instanceof ComboBoxField)) {
            this.formFieldElement = new ComboBoxField("");
        }
        int fieldRotation = this.getRotation();
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rectangle.getHeight(), rectangle.getWidth());
        rectangle = this.applyRotation(fieldRotation, rectangle);
        ComboBoxField comboBoxField = (ComboBoxField)this.formFieldElement;
        this.prepareComboBoxFieldWithCorrectOptionsAndValues(comboBoxField);
        comboBoxField.setFont(this.getFont());
        this.setModelElementProperties(rectangle);
        if (this.getFontSize() <= 0.0f) {
            Rectangle r2 = rectangle.clone();
            float marginToApply = this.borderWidth;
            r2.applyMargins(marginToApply, marginToApply, marginToApply, marginToApply, false);
            UnitValue estimatedFontSize = UnitValue.createPointValue(this.getFontSize(new PdfArray(r2), this.parent.getValueAsString()));
            comboBoxField.setFontSize(estimatedFontSize.getValue());
        } else {
            comboBoxField.setFontSize(this.getFontSize());
        }
        if (this.getColor() != null) {
            comboBoxField.setFontColor(this.getColor());
        }
        comboBoxField.setTextAlignment(this.parent.getJustification());
        Rectangle pdfXobjectRectangle = new Rectangle(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight());
        PdfFormXObject xObject = new PdfFormXObject(pdfXobjectRectangle);
        if (matrix != null) {
            xObject.put(PdfName.Matrix, matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        canvas.setProperty(82, Boolean.TRUE);
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        canvas.setFont(this.getFont());
        canvas.getPdfCanvas().beginVariableText().saveState().endPath();
        canvas.add(comboBoxField);
        canvas.getPdfCanvas().restoreState().endVariableText();
        this.getWidget().setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        this.formFieldElement.setInteractive(true);
    }

    private void prepareComboBoxFieldWithCorrectOptionsAndValues(ComboBoxField comboBoxField) {
        for (PdfObject option : this.parent.getOptions()) {
            SelectFieldItem item = null;
            if (option.isString()) {
                item = new SelectFieldItem(((PdfString)option).getValue());
            }
            if (option.isArray()) {
                assert (option instanceof PdfArray);
                PdfArray array = (PdfArray)option;
                int thereShouldBeTwoElementsInArray = 2;
                if (array.size() == 2) {
                    String exportValue = ((PdfString)array.get(0)).getValue();
                    String displayValue = ((PdfString)array.get(1)).getValue();
                    item = new SelectFieldItem(exportValue, displayValue);
                }
            }
            if (item == null || comboBoxField.getOption(item.getExportValue()) != null) continue;
            comboBoxField.addOption(item);
        }
        comboBoxField.setSelected(this.parent.getDisplayValue());
    }

    protected void drawCheckBoxAndSaveAppearance(String onStateName) {
        Rectangle rect = this.getRect(this.getPdfObject());
        if (rect == null) {
            return;
        }
        int fieldRotation = this.getRotation();
        PdfArray matrix = PdfFormAnnotation.getRotationMatrix(fieldRotation, rect.getHeight(), rect.getWidth());
        rect = this.applyRotation(fieldRotation, rect);
        this.reconstructCheckBoxType();
        this.createCheckBox();
        this.setModelElementProperties(rect);
        boolean wasChecked = Boolean.TRUE.equals(this.formFieldElement.getProperty(0x200007));
        PdfDictionary normalAppearance = new PdfDictionary();
        ((CheckBox)this.formFieldElement).setChecked(false);
        PdfFormXObject xObjectOff = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        if (matrix != null) {
            xObjectOff.put(PdfName.Matrix, matrix);
        }
        Canvas canvasOff = new Canvas(xObjectOff, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvasOff);
        canvasOff.add(this.formFieldElement);
        if (this.getPdfConformance() == null || !this.getPdfConformance().isPdfAOrUa()) {
            xObjectOff.getResources().addFont(this.getDocument(), this.getFont());
        }
        normalAppearance.put(new PdfName(OFF_STATE_VALUE), (PdfObject)xObjectOff.getPdfObject());
        String onStateNameForAp = onStateName;
        if (onStateName == null || onStateName.isEmpty() || OFF_STATE_VALUE.equals(onStateName)) {
            onStateNameForAp = ON_STATE_VALUE;
        }
        ((CheckBox)this.formFieldElement).setChecked(true);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        if (matrix != null) {
            xObject.put(PdfName.Matrix, matrix);
        }
        Canvas canvas = new Canvas(xObject, this.getDocument());
        PdfFormAnnotation.setMetaInfoToCanvas(canvas);
        canvas.add(this.formFieldElement);
        normalAppearance.put(new PdfName(onStateNameForAp), (PdfObject)xObject.getPdfObject());
        this.getWidget().setNormalAppearance(normalAppearance);
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, new PdfString(PdfCheckBoxRenderingStrategy.ZAPFDINGBATS_CHECKBOX_MAPPING.getByKey(this.parent.checkType.getValue())));
        if (fieldRotation != 0) {
            mk.put(PdfName.R, new PdfNumber(fieldRotation));
        }
        this.getWidget().put(PdfName.MK, mk);
        this.formFieldElement.setInteractive(true);
        ((CheckBox)this.formFieldElement).setChecked(wasChecked);
    }

    static void setMetaInfoToCanvas(Canvas canvas) {
        MetaInfoContainer metaInfo = FormsMetaInfoStaticContainer.getMetaInfoForLayout();
        if (metaInfo != null) {
            canvas.setProperty(135, metaInfo);
        }
    }

    boolean regenerateWidget() {
        if (this.fontRequiredForRegeneration()) {
            return false;
        }
        if (!this.isFieldRegenerationEnabled()) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        PdfName type = this.parent.getFormType();
        this.retrieveStyles();
        if (PdfName.Ch.equals(type)) {
            if (this.parent.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
                this.drawComboBoxAndSaveAppearance();
                return true;
            }
            this.drawListFormFieldAndSaveAppearance();
            return true;
        }
        if (PdfName.Tx.equals(type)) {
            this.drawTextFormFieldAndSaveAppearance();
            return true;
        }
        if (PdfName.Btn.equals(type)) {
            if (this.parent.getFieldFlag(PdfButtonFormField.FF_PUSH_BUTTON)) {
                this.drawPushButtonFieldAndSaveAppearance();
            } else if (this.parent.getFieldFlag(PdfButtonFormField.FF_RADIO)) {
                this.drawRadioButtonAndSaveAppearance(this.getRadioButtonValue());
            } else {
                this.drawCheckBoxAndSaveAppearance(this.getCheckBoxValue());
            }
            return true;
        }
        if (PdfName.Sig.equals(type)) {
            this.drawSignatureFormFieldAndSaveAppearance();
            return true;
        }
        return false;
    }

    private boolean fontRequiredForRegeneration() {
        if (this.getFont() != null) {
            return false;
        }
        if (this.parent instanceof PdfButtonFormField) {
            return ((PdfButtonFormField)this.parent).isPushButton();
        }
        return !(this.parent instanceof PdfSignatureFormField);
    }

    void createInputButton() {
        if (!(this.formFieldElement instanceof Button)) {
            this.formFieldElement = new Button("");
        }
        ((Button)this.formFieldElement).setFont(this.getFont());
        if (this.getColor() != null) {
            ((Button)this.formFieldElement).setFontColor(this.color);
        }
    }

    void createSigField() {
        if (!(this.formFieldElement instanceof SignatureFieldAppearance)) {
            this.formFieldElement = new SignatureFieldAppearance("");
        }
        if (this.formFieldElement.getProperty(20) == null) {
            ((SignatureFieldAppearance)this.formFieldElement).setFont(this.getFont());
        }
        if (this.getColor() != null) {
            ((SignatureFieldAppearance)this.formFieldElement).setFontColor(this.color);
        }
        if (((SignatureFieldAppearance)this.formFieldElement).getContentElements().isEmpty()) {
            PdfString date;
            PdfString location;
            PdfString reason;
            SignedAppearanceText description = new SignedAppearanceText();
            PdfName name = this.parent.getPdfObject().getAsName(PdfName.Name);
            if (name != null) {
                description.setSignedBy(name.getValue());
            }
            if ((reason = this.parent.getPdfObject().getAsString(PdfName.Reason)) != null) {
                description.setReasonLine("Reason: " + reason.toUnicodeString());
            }
            if ((location = this.parent.getPdfObject().getAsString(PdfName.Location)) != null) {
                description.setLocationLine("Location: " + location.toUnicodeString());
            }
            if ((date = this.parent.getPdfObject().getAsString(PdfName.M)) != null) {
                description.setSignDate(PdfDate.decode(date.getValue()));
            }
            ((SignatureFieldAppearance)this.formFieldElement).setContent(description);
        }
    }

    float getFontSize(PdfArray bBox, String value) {
        if (this.getFontSize() == 0.0f) {
            if (bBox == null || value == null || value.isEmpty()) {
                return 12.0f;
            }
            return FontSizeUtil.approximateFontSizeToFitSingleLine(this.getFont(), bBox.toRectangle(), value, 4.0f, this.borderWidth);
        }
        return this.getFontSize();
    }

    private boolean isCombTextFormField() {
        PdfName type = this.parent.getFormType();
        if (PdfName.Tx.equals(type)) {
            PdfTextFormField textField;
            PdfTextFormField pdfTextFormField = textField = this.parent instanceof PdfTextFormField ? (PdfTextFormField)this.parent : PdfFormCreator.createTextFormField(this.parent.getPdfObject());
            if (textField.isComb()) {
                if (textField.getMaxLen() == 0 || textField.isMultiline() || textField.isPassword() || textField.isFileSelect()) {
                    LOGGER.error("The Comb flag may be set only if the MaxLen entry is present in the text field dictionary and if the Multiline, Password, and FileSelect flags are clear.");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private String getRadioButtonValue() {
        for (String state : this.getAppearanceStates()) {
            if (OFF_STATE_VALUE.equals(state)) continue;
            return state;
        }
        return null;
    }

    private String getCheckBoxValue() {
        for (String state : this.getAppearanceStates()) {
            if (OFF_STATE_VALUE.equals(state)) continue;
            return state;
        }
        return this.parent.getValueAsString();
    }

    private void reconstructCheckBoxType() {
        PdfString oldCa;
        PdfDictionary oldMk;
        if (this.parent.checkType == null && (oldMk = this.getWidget().getAppearanceCharacteristics()) != null && (oldCa = oldMk.getAsString(PdfName.CA)) != null && PdfCheckBoxRenderingStrategy.ZAPFDINGBATS_CHECKBOX_MAPPING.containsValue(oldCa.getValue())) {
            this.parent.checkType = new NullableContainer<CheckBoxType>(PdfCheckBoxRenderingStrategy.ZAPFDINGBATS_CHECKBOX_MAPPING.getByValue(oldCa.getValue()));
            this.fontSize = 0.0f;
        }
        if (this.parent.checkType == null) {
            this.parent.checkType = new NullableContainer<CheckBoxType>(CheckBoxType.CROSS);
        }
    }

    private void createCheckBox() {
        if (!(this.formFieldElement instanceof CheckBox)) {
            this.formFieldElement = new CheckBox("");
        }
        this.formFieldElement.setProperty(24, UnitValue.createPointValue(this.getFontSize()));
        ((CheckBox)this.formFieldElement).setPdfConformance(this.getPdfConformance());
        ((CheckBox)this.formFieldElement).setCheckBoxType(this.parent.checkType.getValue());
    }

    private void setModelElementProperties(Rectangle rectangle) {
        if (this.backgroundColor != null) {
            this.formFieldElement.setProperty(6, new Background(this.backgroundColor));
        }
        this.formFieldElement.setProperty(13, this.getBorder());
        this.formFieldElement.setProperty(12, this.getBorder());
        this.formFieldElement.setProperty(10, this.getBorder());
        this.formFieldElement.setProperty(11, this.getBorder());
        BoxSizingPropertyValue boxSizing = (BoxSizingPropertyValue)((Object)this.formFieldElement.getProperty(105));
        float extraBorderWidth = 0.0f;
        float extraPaddingsW = 0.0f;
        float extraPaddingsH = 0.0f;
        if (BoxSizingPropertyValue.CONTENT_BOX == boxSizing) {
            UnitValue bPadding;
            UnitValue tPadding;
            UnitValue rPadding;
            extraBorderWidth += 2.0f * this.borderWidth;
            UnitValue lPadding = (UnitValue)this.formFieldElement.getProperty(48);
            if (lPadding != null) {
                extraPaddingsW += lPadding.getValue();
            }
            if ((rPadding = (UnitValue)this.formFieldElement.getProperty(49)) != null) {
                extraPaddingsW += rPadding.getValue();
            }
            if ((tPadding = (UnitValue)this.formFieldElement.getProperty(50)) != null) {
                extraPaddingsH += tPadding.getValue();
            }
            if ((bPadding = (UnitValue)this.formFieldElement.getProperty(47)) != null) {
                extraPaddingsH += bPadding.getValue();
            }
        }
        this.formFieldElement.setWidth(rectangle.getWidth() - extraBorderWidth - extraPaddingsW);
        this.formFieldElement.setHeight(rectangle.getHeight() - extraBorderWidth - extraPaddingsH);
        this.formFieldElement.setInteractive(false);
    }

    private static PdfArray getRotationMatrix(int rotation, float height, float width) {
        int normalizedRotation = rotation % 360;
        if (normalizedRotation < 0) {
            normalizedRotation += 360;
        }
        switch (normalizedRotation) {
            case 0: {
                return null;
            }
            case 90: {
                return new PdfArray(new float[]{0.0f, 1.0f, -1.0f, 0.0f, height, 0.0f});
            }
            case 180: {
                return new PdfArray(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, width, height});
            }
            case 270: {
                return new PdfArray(new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, width});
            }
        }
        Logger logger = LoggerFactory.getLogger(PdfFormAnnotation.class);
        logger.error("Encountered a widget rotation that was not a multiple of 90\u00b0/ (Pi/2) when generating default appearances for form fields");
        return null;
    }

    private static Color appearancePropToColor(PdfDictionary appearanceCharacteristics, PdfName property) {
        PdfArray colorData = appearanceCharacteristics.getAsArray(property);
        if (colorData != null) {
            float[] backgroundFloat = new float[colorData.size()];
            for (int i = 0; i < colorData.size(); ++i) {
                backgroundFloat[i] = colorData.getAsNumber(i).floatValue();
            }
            switch (colorData.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new DeviceGray(backgroundFloat[0]);
                }
                case 3: {
                    return new DeviceRgb(backgroundFloat[0], backgroundFloat[1], backgroundFloat[2]);
                }
                case 4: {
                    return new DeviceCmyk(backgroundFloat[0], backgroundFloat[1], backgroundFloat[2], backgroundFloat[3]);
                }
            }
        }
        return null;
    }

    private static String appearancePropToCaption(PdfDictionary appearanceCharacteristics) {
        PdfString captionData = appearanceCharacteristics.getAsString(PdfName.CA);
        if (captionData != null) {
            return captionData.getValue();
        }
        return null;
    }

    private boolean isCheckBox() {
        return this.parent != null && PdfName.Btn.equals(this.parent.getFormType()) && !this.parent.getFieldFlag(PdfButtonFormField.FF_RADIO) && !this.parent.getFieldFlag(PdfButtonFormField.FF_PUSH_BUTTON);
    }

    private static boolean isFieldInvisible(Rectangle rect) {
        return rect == null || Math.abs(rect.getWidth()) < 1.0E-4f || Math.abs(rect.getHeight()) < 1.0E-4f;
    }

    private PdfFormXObject createTopLayer(float width, float height) {
        PdfFormXObject topLayerXObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        PdfCanvas topLayerCanvas = new PdfCanvas(topLayerXObject, this.getDocument());
        PdfFormXObject n0LayerXObject = this.createN0Layer(width, height);
        topLayerXObject.getResources().addForm(n0LayerXObject, new PdfName("n0"));
        topLayerCanvas.addXObjectWithTransformationMatrix(n0LayerXObject, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        PdfFormXObject n2LayerXObject = this.createN2Layer(width, height);
        topLayerXObject.getResources().addForm(n2LayerXObject, new PdfName("n2"));
        topLayerCanvas.addXObjectWithTransformationMatrix(n2LayerXObject, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        return topLayerXObject;
    }

    private PdfFormXObject createN0Layer(float width, float height) {
        if (((PdfSignatureFormField)this.parent).getBackgroundLayer() != null) {
            return ((PdfSignatureFormField)this.parent).getBackgroundLayer();
        }
        PdfFormXObject n0LayerXObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        n0LayerXObject.makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(n0LayerXObject, this.getDocument());
        canvas.writeLiteral("% DSBlank\n");
        if (((PdfSignatureFormField)this.parent).isReuseAppearance()) {
            PdfAcroForm acroForm = PdfFormCreator.getAcroForm(this.getDocument(), true);
            PdfFormField field = acroForm.getField(this.parent.getFieldName().toUnicodeString());
            PdfStream oldAppearanceStream = field.getWidgets().get(0).getAppearanceDictionary().getAsStream(PdfName.N);
            if (oldAppearanceStream != null) {
                n0LayerXObject = new PdfFormXObject(oldAppearanceStream);
            } else {
                ((PdfSignatureFormField)this.parent).setReuseAppearance(false);
            }
        }
        return n0LayerXObject;
    }

    private PdfFormXObject createN2Layer(float width, float height) {
        if (((PdfSignatureFormField)this.parent).getSignatureAppearanceLayer() != null) {
            return ((PdfSignatureFormField)this.parent).getSignatureAppearanceLayer();
        }
        PdfFormXObject n2LayerXObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        Canvas n2LayerCanvas = new Canvas(n2LayerXObject, this.getDocument());
        PdfPage page = this.getWidget().getPage();
        int rotation = page == null ? 0 : page.getRotation();
        float squeezeTransformation = height / width;
        if (rotation == 90) {
            n2LayerCanvas.getPdfCanvas().concatMatrix(0.0, squeezeTransformation, -1.0f / squeezeTransformation, 0.0, width, 0.0);
        } else if (rotation == 180) {
            n2LayerCanvas.getPdfCanvas().concatMatrix(-1.0, 0.0, 0.0, -1.0, width, height);
        } else if (rotation == 270) {
            n2LayerCanvas.getPdfCanvas().concatMatrix(0.0, -squeezeTransformation, 1.0f / squeezeTransformation, 0.0, 0.0, height);
        }
        n2LayerCanvas.add(this.formFieldElement);
        n2LayerCanvas.setProperty(108, null);
        n2LayerCanvas.close();
        return n2LayerXObject;
    }

    private Rectangle applyRotation(int fieldRotation, Rectangle rectangle) {
        if (fieldRotation / 90 % 2 != 0) {
            Rectangle invertedRectangle = rectangle.clone();
            invertedRectangle.setWidth(rectangle.getHeight());
            invertedRectangle.setHeight(rectangle.getWidth());
            rectangle = invertedRectangle;
        }
        return rectangle;
    }

    private void updateParentFontSize(float fontSize) {
        if (this.parent != null) {
            this.parent.updateFontAndFontSize(this.parent.getFont(), fontSize);
            this.parent.updateDefaultAppearance();
        }
    }
}

