/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Monitoring
extends Base {
    private final boolean collectionEnabled;
    private final Map<String, Long> enabledExporters;
    public static final JsonpDeserializer<Monitoring> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Monitoring::setupMonitoringDeserializer);

    private Monitoring(Builder builder) {
        super(builder);
        this.collectionEnabled = ApiTypeHelper.requireNonNull(builder.collectionEnabled, this, "collectionEnabled");
        this.enabledExporters = ApiTypeHelper.unmodifiableRequired(builder.enabledExporters, (Object)this, "enabledExporters");
    }

    public static Monitoring of(Function<Builder, ObjectBuilder<Monitoring>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean collectionEnabled() {
        return this.collectionEnabled;
    }

    public final Map<String, Long> enabledExporters() {
        return this.enabledExporters;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("collection_enabled");
        generator.write(this.collectionEnabled);
        if (ApiTypeHelper.isDefined(this.enabledExporters)) {
            generator.writeKey("enabled_exporters");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.enabledExporters.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupMonitoringDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::collectionEnabled, JsonpDeserializer.booleanDeserializer(), "collection_enabled");
        op.add(Builder::enabledExporters, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "enabled_exporters");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Monitoring> {
        private Boolean collectionEnabled;
        private Map<String, Long> enabledExporters;

        public final Builder collectionEnabled(boolean value) {
            this.collectionEnabled = value;
            return this;
        }

        public final Builder enabledExporters(Map<String, Long> map) {
            this.enabledExporters = Builder._mapPutAll(this.enabledExporters, map);
            return this;
        }

        public final Builder enabledExporters(String key, Long value) {
            this.enabledExporters = Builder._mapPut(this.enabledExporters, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Monitoring build() {
            this._checkSingleUse();
            return new Monitoring(this);
        }
    }
}

