/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.rollup.FieldMetric;
import co.elastic.clients.elasticsearch.rollup.Groupings;
import co.elastic.clients.elasticsearch.rollup.PutJobResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutJobRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String cron;
    @Nullable
    private final Groupings groups;
    private final String id;
    @Nullable
    private final String indexPattern;
    private final List<FieldMetric> metrics;
    @Nullable
    private final Long pageSize;
    @Nullable
    private final String rollupIndex;
    public static final JsonpDeserializer<PutJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutJobRequest::setupPutJobRequestDeserializer);
    public static final Endpoint<PutJobRequest, PutJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutJobRequest, PutJobResponse>("es/rollup.put_job", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_rollup");
            buf.append("/job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutJobResponse._DESERIALIZER);

    private PutJobRequest(Builder builder) {
        this.cron = builder.cron;
        this.groups = builder.groups;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.indexPattern = builder.indexPattern;
        this.metrics = ApiTypeHelper.unmodifiable(builder.metrics);
        this.pageSize = builder.pageSize;
        this.rollupIndex = builder.rollupIndex;
    }

    public static PutJobRequest of(Function<Builder, ObjectBuilder<PutJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String cron() {
        return this.cron;
    }

    @Nullable
    public final Groupings groups() {
        return this.groups;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final String indexPattern() {
        return this.indexPattern;
    }

    public final List<FieldMetric> metrics() {
        return this.metrics;
    }

    @Nullable
    public final Long pageSize() {
        return this.pageSize;
    }

    @Nullable
    public final String rollupIndex() {
        return this.rollupIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cron != null) {
            generator.writeKey("cron");
            generator.write(this.cron);
        }
        if (this.groups != null) {
            generator.writeKey("groups");
            this.groups.serialize(generator, mapper);
        }
        if (this.indexPattern != null) {
            generator.writeKey("index_pattern");
            generator.write(this.indexPattern);
        }
        if (ApiTypeHelper.isDefined(this.metrics)) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (FieldMetric item0 : this.metrics) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.pageSize != null) {
            generator.writeKey("page_size");
            generator.write(this.pageSize);
        }
        if (this.rollupIndex != null) {
            generator.writeKey("rollup_index");
            generator.write(this.rollupIndex);
        }
    }

    protected static void setupPutJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), "cron");
        op.add(Builder::groups, Groupings._DESERIALIZER, "groups");
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern");
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(FieldMetric._DESERIALIZER), "metrics");
        op.add(Builder::pageSize, JsonpDeserializer.longDeserializer(), "page_size");
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutJobRequest> {
        @Nullable
        private String cron;
        @Nullable
        private Groupings groups;
        private String id;
        @Nullable
        private String indexPattern;
        @Nullable
        private List<FieldMetric> metrics;
        @Nullable
        private Long pageSize;
        @Nullable
        private String rollupIndex;

        public final Builder cron(@Nullable String value) {
            this.cron = value;
            return this;
        }

        public final Builder groups(@Nullable Groupings value) {
            this.groups = value;
            return this;
        }

        public final Builder groups(Function<Groupings.Builder, ObjectBuilder<Groupings>> fn) {
            return this.groups(fn.apply(new Groupings.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder indexPattern(@Nullable String value) {
            this.indexPattern = value;
            return this;
        }

        public final Builder metrics(List<FieldMetric> list) {
            this.metrics = Builder._listAddAll(this.metrics, list);
            return this;
        }

        public final Builder metrics(FieldMetric value, FieldMetric ... values) {
            this.metrics = Builder._listAdd(this.metrics, value, values);
            return this;
        }

        public final Builder metrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.metrics(fn.apply(new FieldMetric.Builder()).build(), new FieldMetric[0]);
        }

        public final Builder pageSize(@Nullable Long value) {
            this.pageSize = value;
            return this;
        }

        public final Builder rollupIndex(@Nullable String value) {
            this.rollupIndex = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutJobRequest build() {
            this._checkSingleUse();
            return new PutJobRequest(this);
        }
    }
}

