/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfig;
import co.elastic.clients.elasticsearch.ml.TrainedModelConfigInput;
import co.elastic.clients.elasticsearch.ml.TrainedModelConfigMetadata;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelConfig
implements JsonpSerializable {
    private final String modelId;
    private final List<String> tags;
    @Nullable
    private final String version;
    @Nullable
    private final String compressedDefinition;
    @Nullable
    private final String createdBy;
    @Nullable
    private final Time createTime;
    private final Map<String, String> defaultFieldMap;
    @Nullable
    private final String description;
    @Nullable
    private final Integer estimatedHeapMemoryUsageBytes;
    @Nullable
    private final Integer estimatedOperations;
    private final InferenceConfig inferenceConfig;
    private final TrainedModelConfigInput input;
    @Nullable
    private final String licenseLevel;
    @Nullable
    private final TrainedModelConfigMetadata metadata;
    public static final JsonpDeserializer<TrainedModelConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelConfig::setupTrainedModelConfigDeserializer);

    protected TrainedModelConfig(AbstractBuilder<?> builder) {
        this.modelId = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).modelId, this, "modelId");
        this.tags = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).tags, (Object)this, "tags");
        this.version = ((AbstractBuilder)builder).version;
        this.compressedDefinition = ((AbstractBuilder)builder).compressedDefinition;
        this.createdBy = ((AbstractBuilder)builder).createdBy;
        this.createTime = ((AbstractBuilder)builder).createTime;
        this.defaultFieldMap = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).defaultFieldMap);
        this.description = ((AbstractBuilder)builder).description;
        this.estimatedHeapMemoryUsageBytes = ((AbstractBuilder)builder).estimatedHeapMemoryUsageBytes;
        this.estimatedOperations = ((AbstractBuilder)builder).estimatedOperations;
        this.inferenceConfig = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).inferenceConfig, this, "inferenceConfig");
        this.input = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).input, this, "input");
        this.licenseLevel = ((AbstractBuilder)builder).licenseLevel;
        this.metadata = ((AbstractBuilder)builder).metadata;
    }

    public static TrainedModelConfig trainedModelConfigOf(Function<Builder, ObjectBuilder<TrainedModelConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    public final List<String> tags() {
        return this.tags;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final String compressedDefinition() {
        return this.compressedDefinition;
    }

    @Nullable
    public final String createdBy() {
        return this.createdBy;
    }

    @Nullable
    public final Time createTime() {
        return this.createTime;
    }

    public final Map<String, String> defaultFieldMap() {
        return this.defaultFieldMap;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Integer estimatedHeapMemoryUsageBytes() {
        return this.estimatedHeapMemoryUsageBytes;
    }

    @Nullable
    public final Integer estimatedOperations() {
        return this.estimatedOperations;
    }

    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final TrainedModelConfigInput input() {
        return this.input;
    }

    @Nullable
    public final String licenseLevel() {
        return this.licenseLevel;
    }

    @Nullable
    public final TrainedModelConfigMetadata metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (ApiTypeHelper.isDefined(this.tags)) {
            generator.writeKey("tags");
            generator.writeStartArray();
            for (String string : this.tags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.compressedDefinition != null) {
            generator.writeKey("compressed_definition");
            generator.write(this.compressedDefinition);
        }
        if (this.createdBy != null) {
            generator.writeKey("created_by");
            generator.write(this.createdBy);
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            this.createTime.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.defaultFieldMap)) {
            generator.writeKey("default_field_map");
            generator.writeStartObject();
            for (Map.Entry entry : this.defaultFieldMap.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.estimatedHeapMemoryUsageBytes != null) {
            generator.writeKey("estimated_heap_memory_usage_bytes");
            generator.write(this.estimatedHeapMemoryUsageBytes);
        }
        if (this.estimatedOperations != null) {
            generator.writeKey("estimated_operations");
            generator.write(this.estimatedOperations);
        }
        generator.writeKey("inference_config");
        this.inferenceConfig.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (this.licenseLevel != null) {
            generator.writeKey("license_level");
            generator.write(this.licenseLevel);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            this.metadata.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTrainedModelConfigDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(AbstractBuilder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags");
        op.add(AbstractBuilder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(AbstractBuilder::compressedDefinition, JsonpDeserializer.stringDeserializer(), "compressed_definition");
        op.add(AbstractBuilder::createdBy, JsonpDeserializer.stringDeserializer(), "created_by");
        op.add(AbstractBuilder::createTime, Time._DESERIALIZER, "create_time");
        op.add(AbstractBuilder::defaultFieldMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "default_field_map");
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::estimatedHeapMemoryUsageBytes, JsonpDeserializer.integerDeserializer(), "estimated_heap_memory_usage_bytes");
        op.add(AbstractBuilder::estimatedOperations, JsonpDeserializer.integerDeserializer(), "estimated_operations");
        op.add(AbstractBuilder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config");
        op.add(AbstractBuilder::input, TrainedModelConfigInput._DESERIALIZER, "input");
        op.add(AbstractBuilder::licenseLevel, JsonpDeserializer.stringDeserializer(), "license_level");
        op.add(AbstractBuilder::metadata, TrainedModelConfigMetadata._DESERIALIZER, "metadata");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String modelId;
        private List<String> tags;
        @Nullable
        private String version;
        @Nullable
        private String compressedDefinition;
        @Nullable
        private String createdBy;
        @Nullable
        private Time createTime;
        @Nullable
        private Map<String, String> defaultFieldMap;
        @Nullable
        private String description;
        @Nullable
        private Integer estimatedHeapMemoryUsageBytes;
        @Nullable
        private Integer estimatedOperations;
        private InferenceConfig inferenceConfig;
        private TrainedModelConfigInput input;
        @Nullable
        private String licenseLevel;
        @Nullable
        private TrainedModelConfigMetadata metadata;

        public final BuilderT modelId(String value) {
            this.modelId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tags(List<String> list) {
            this.tags = AbstractBuilder._listAddAll(this.tags, list);
            return (BuilderT)this.self();
        }

        public final BuilderT tags(String value, String ... values) {
            this.tags = AbstractBuilder._listAdd(this.tags, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT version(@Nullable String value) {
            this.version = value;
            return (BuilderT)this.self();
        }

        public final BuilderT compressedDefinition(@Nullable String value) {
            this.compressedDefinition = value;
            return (BuilderT)this.self();
        }

        public final BuilderT createdBy(@Nullable String value) {
            this.createdBy = value;
            return (BuilderT)this.self();
        }

        public final BuilderT createTime(@Nullable Time value) {
            this.createTime = value;
            return (BuilderT)this.self();
        }

        public final BuilderT createTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.createTime(fn.apply(new Time.Builder()).build());
        }

        public final BuilderT defaultFieldMap(Map<String, String> map) {
            this.defaultFieldMap = AbstractBuilder._mapPutAll(this.defaultFieldMap, map);
            return (BuilderT)this.self();
        }

        public final BuilderT defaultFieldMap(String key, String value) {
            this.defaultFieldMap = AbstractBuilder._mapPut(this.defaultFieldMap, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return (BuilderT)this.self();
        }

        public final BuilderT estimatedHeapMemoryUsageBytes(@Nullable Integer value) {
            this.estimatedHeapMemoryUsageBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT estimatedOperations(@Nullable Integer value) {
            this.estimatedOperations = value;
            return (BuilderT)this.self();
        }

        public final BuilderT inferenceConfig(InferenceConfig value) {
            this.inferenceConfig = value;
            return (BuilderT)this.self();
        }

        public final BuilderT inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        public final BuilderT input(TrainedModelConfigInput value) {
            this.input = value;
            return (BuilderT)this.self();
        }

        public final BuilderT input(Function<TrainedModelConfigInput.Builder, ObjectBuilder<TrainedModelConfigInput>> fn) {
            return this.input(fn.apply(new TrainedModelConfigInput.Builder()).build());
        }

        public final BuilderT licenseLevel(@Nullable String value) {
            this.licenseLevel = value;
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(@Nullable TrainedModelConfigMetadata value) {
            this.metadata = value;
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(Function<TrainedModelConfigMetadata.Builder, ObjectBuilder<TrainedModelConfigMetadata>> fn) {
            return this.metadata(fn.apply(new TrainedModelConfigMetadata.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<TrainedModelConfig> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelConfig build() {
            this._checkSingleUse();
            return new TrainedModelConfig(this);
        }
    }
}

