/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.StopDatafeedResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StopDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoDatafeeds;
    @Nullable
    private final Boolean allowNoMatch;
    private final String datafeedId;
    @Nullable
    private final Boolean force;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<StopDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopDatafeedRequest::setupStopDatafeedRequestDeserializer);
    public static final Endpoint<StopDatafeedRequest, StopDatafeedResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StopDatafeedRequest, StopDatafeedResponse>("es/ml.stop_datafeed", request -> "POST", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoDatafeeds != null) {
            params.put("allow_no_datafeeds", String.valueOf(request.allowNoDatafeeds));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, StopDatafeedResponse._DESERIALIZER);

    private StopDatafeedRequest(Builder builder) {
        this.allowNoDatafeeds = builder.allowNoDatafeeds;
        this.allowNoMatch = builder.allowNoMatch;
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.force = builder.force;
        this.timeout = builder.timeout;
    }

    public static StopDatafeedRequest of(Function<Builder, ObjectBuilder<StopDatafeedRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final Boolean allowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.force != null) {
            generator.writeKey("force");
            generator.write(this.force);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    protected static void setupStopDatafeedRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::force, JsonpDeserializer.booleanDeserializer(), "force");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StopDatafeedRequest> {
        @Nullable
        private Boolean allowNoDatafeeds;
        @Nullable
        private Boolean allowNoMatch;
        private String datafeedId;
        @Nullable
        private Boolean force;
        @Nullable
        private Time timeout;

        @Deprecated
        public final Builder allowNoDatafeeds(@Nullable Boolean value) {
            this.allowNoDatafeeds = value;
            return this;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StopDatafeedRequest build() {
            this._checkSingleUse();
            return new StopDatafeedRequest(this);
        }
    }
}

