/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license.get;

import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LicenseInformation
implements JsonpSerializable {
    private final String expiryDate;
    private final String expiryDateInMillis;
    private final String issueDate;
    private final String issueDateInMillis;
    private final String issuedTo;
    private final String issuer;
    private final long maxNodes;
    @Nullable
    private final Integer maxResourceUnits;
    private final LicenseStatus status;
    private final LicenseType type;
    private final String uid;
    private final String startDateInMillis;
    public static final JsonpDeserializer<LicenseInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LicenseInformation::setupLicenseInformationDeserializer);

    private LicenseInformation(Builder builder) {
        this.expiryDate = ApiTypeHelper.requireNonNull(builder.expiryDate, this, "expiryDate");
        this.expiryDateInMillis = ApiTypeHelper.requireNonNull(builder.expiryDateInMillis, this, "expiryDateInMillis");
        this.issueDate = ApiTypeHelper.requireNonNull(builder.issueDate, this, "issueDate");
        this.issueDateInMillis = ApiTypeHelper.requireNonNull(builder.issueDateInMillis, this, "issueDateInMillis");
        this.issuedTo = ApiTypeHelper.requireNonNull(builder.issuedTo, this, "issuedTo");
        this.issuer = ApiTypeHelper.requireNonNull(builder.issuer, this, "issuer");
        this.maxNodes = ApiTypeHelper.requireNonNull(builder.maxNodes, this, "maxNodes");
        this.maxResourceUnits = builder.maxResourceUnits;
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.uid = ApiTypeHelper.requireNonNull(builder.uid, this, "uid");
        this.startDateInMillis = ApiTypeHelper.requireNonNull(builder.startDateInMillis, this, "startDateInMillis");
    }

    public static LicenseInformation of(Function<Builder, ObjectBuilder<LicenseInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String expiryDate() {
        return this.expiryDate;
    }

    public final String expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public final String issueDate() {
        return this.issueDate;
    }

    public final String issueDateInMillis() {
        return this.issueDateInMillis;
    }

    public final String issuedTo() {
        return this.issuedTo;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final long maxNodes() {
        return this.maxNodes;
    }

    @Nullable
    public final Integer maxResourceUnits() {
        return this.maxResourceUnits;
    }

    public final LicenseStatus status() {
        return this.status;
    }

    public final LicenseType type() {
        return this.type;
    }

    public final String uid() {
        return this.uid;
    }

    public final String startDateInMillis() {
        return this.startDateInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expiry_date");
        generator.write(this.expiryDate);
        generator.writeKey("expiry_date_in_millis");
        generator.write(this.expiryDateInMillis);
        generator.writeKey("issue_date");
        generator.write(this.issueDate);
        generator.writeKey("issue_date_in_millis");
        generator.write(this.issueDateInMillis);
        generator.writeKey("issued_to");
        generator.write(this.issuedTo);
        generator.writeKey("issuer");
        generator.write(this.issuer);
        generator.writeKey("max_nodes");
        generator.write(this.maxNodes);
        if (this.maxResourceUnits != null) {
            generator.writeKey("max_resource_units");
            generator.write(this.maxResourceUnits);
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
        generator.writeKey("start_date_in_millis");
        generator.write(this.startDateInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupLicenseInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expiryDate, JsonpDeserializer.stringDeserializer(), "expiry_date");
        op.add(Builder::expiryDateInMillis, JsonpDeserializer.stringDeserializer(), "expiry_date_in_millis");
        op.add(Builder::issueDate, JsonpDeserializer.stringDeserializer(), "issue_date");
        op.add(Builder::issueDateInMillis, JsonpDeserializer.stringDeserializer(), "issue_date_in_millis");
        op.add(Builder::issuedTo, JsonpDeserializer.stringDeserializer(), "issued_to");
        op.add(Builder::issuer, JsonpDeserializer.stringDeserializer(), "issuer");
        op.add(Builder::maxNodes, JsonpDeserializer.longDeserializer(), "max_nodes");
        op.add(Builder::maxResourceUnits, JsonpDeserializer.integerDeserializer(), "max_resource_units");
        op.add(Builder::status, LicenseStatus._DESERIALIZER, "status");
        op.add(Builder::type, LicenseType._DESERIALIZER, "type");
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid");
        op.add(Builder::startDateInMillis, JsonpDeserializer.stringDeserializer(), "start_date_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LicenseInformation> {
        private String expiryDate;
        private String expiryDateInMillis;
        private String issueDate;
        private String issueDateInMillis;
        private String issuedTo;
        private String issuer;
        private Long maxNodes;
        @Nullable
        private Integer maxResourceUnits;
        private LicenseStatus status;
        private LicenseType type;
        private String uid;
        private String startDateInMillis;

        public final Builder expiryDate(String value) {
            this.expiryDate = value;
            return this;
        }

        public final Builder expiryDateInMillis(String value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public final Builder issueDate(String value) {
            this.issueDate = value;
            return this;
        }

        public final Builder issueDateInMillis(String value) {
            this.issueDateInMillis = value;
            return this;
        }

        public final Builder issuedTo(String value) {
            this.issuedTo = value;
            return this;
        }

        public final Builder issuer(String value) {
            this.issuer = value;
            return this;
        }

        public final Builder maxNodes(long value) {
            this.maxNodes = value;
            return this;
        }

        public final Builder maxResourceUnits(@Nullable Integer value) {
            this.maxResourceUnits = value;
            return this;
        }

        public final Builder status(LicenseStatus value) {
            this.status = value;
            return this;
        }

        public final Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public final Builder uid(String value) {
            this.uid = value;
            return this;
        }

        public final Builder startDateInMillis(String value) {
            this.startDateInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LicenseInformation build() {
            this._checkSingleUse();
            return new LicenseInformation(this);
        }
    }
}

