/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ObjectProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<ObjectProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ObjectProperty::setupObjectPropertyDeserializer);

    private ObjectProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
    }

    public static ObjectProperty of(Function<Builder, ObjectBuilder<ObjectProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Object;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "object");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled);
        }
    }

    protected static void setupObjectPropertyDeserializer(ObjectDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ObjectProperty> {
        @Nullable
        private Boolean enabled;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ObjectProperty build() {
            this._checkSingleUse();
            return new ObjectProperty(this);
        }
    }
}

