/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.TermsExclude;
import co.elastic.clients.elasticsearch._types.aggregations.TermsInclude;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RareTermsAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final TermsExclude exclude;
    @Nullable
    private final String field;
    @Nullable
    private final TermsInclude include;
    @Nullable
    private final Long maxDocCount;
    @Nullable
    private final FieldValue missing;
    @Nullable
    private final Double precision;
    @Nullable
    private final String valueType;
    public static final JsonpDeserializer<RareTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RareTermsAggregation::setupRareTermsAggregationDeserializer);

    private RareTermsAggregation(Builder builder) {
        super(builder);
        this.exclude = builder.exclude;
        this.field = builder.field;
        this.include = builder.include;
        this.maxDocCount = builder.maxDocCount;
        this.missing = builder.missing;
        this.precision = builder.precision;
        this.valueType = builder.valueType;
    }

    public static RareTermsAggregation of(Function<Builder, ObjectBuilder<RareTermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.RareTerms;
    }

    @Nullable
    public final TermsExclude exclude() {
        return this.exclude;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final TermsInclude include() {
        return this.include;
    }

    @Nullable
    public final Long maxDocCount() {
        return this.maxDocCount;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nullable
    public final Double precision() {
        return this.precision;
    }

    @Nullable
    public final String valueType() {
        return this.valueType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.exclude != null) {
            generator.writeKey("exclude");
            this.exclude.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.maxDocCount != null) {
            generator.writeKey("max_doc_count");
            generator.write(this.maxDocCount);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            generator.write(this.valueType);
        }
    }

    protected static void setupRareTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::exclude, TermsExclude._DESERIALIZER, "exclude");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::include, TermsInclude._DESERIALIZER, "include");
        op.add(Builder::maxDocCount, JsonpDeserializer.longDeserializer(), "max_doc_count");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(Builder::precision, JsonpDeserializer.doubleDeserializer(), "precision");
        op.add(Builder::valueType, JsonpDeserializer.stringDeserializer(), "value_type");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RareTermsAggregation> {
        @Nullable
        private TermsExclude exclude;
        @Nullable
        private String field;
        @Nullable
        private TermsInclude include;
        @Nullable
        private Long maxDocCount;
        @Nullable
        private FieldValue missing;
        @Nullable
        private Double precision;
        @Nullable
        private String valueType;

        public final Builder exclude(@Nullable TermsExclude value) {
            this.exclude = value;
            return this;
        }

        public final Builder exclude(Function<TermsExclude.Builder, ObjectBuilder<TermsExclude>> fn) {
            return this.exclude(fn.apply(new TermsExclude.Builder()).build());
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder include(@Nullable TermsInclude value) {
            this.include = value;
            return this;
        }

        public final Builder include(Function<TermsInclude.Builder, ObjectBuilder<TermsInclude>> fn) {
            return this.include(fn.apply(new TermsInclude.Builder()).build());
        }

        public final Builder maxDocCount(@Nullable Long value) {
            this.maxDocCount = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder missing(String value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(long value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(double value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(boolean value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder precision(@Nullable Double value) {
            this.precision = value;
            return this;
        }

        public final Builder valueType(@Nullable String value) {
            this.valueType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RareTermsAggregation build() {
            this._checkSingleUse();
            return new RareTermsAggregation(this);
        }
    }
}

