/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RangeBucket
extends MultiBucketBase {
    @Nullable
    private final Double from;
    @Nullable
    private final Double to;
    @Nullable
    private final String fromAsString;
    @Nullable
    private final String toAsString;
    @Nullable
    private final String key;
    public static final JsonpDeserializer<RangeBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeBucket::setupRangeBucketDeserializer);

    private RangeBucket(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.to = builder.to;
        this.fromAsString = builder.fromAsString;
        this.toAsString = builder.toAsString;
        this.key = builder.key;
    }

    public static RangeBucket of(Function<Builder, ObjectBuilder<RangeBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double from() {
        return this.from;
    }

    @Nullable
    public final Double to() {
        return this.to;
    }

    @Nullable
    public final String fromAsString() {
        return this.fromAsString;
    }

    @Nullable
    public final String toAsString() {
        return this.toAsString;
    }

    @Nullable
    public final String key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from);
        }
        if (this.to != null) {
            generator.writeKey("to");
            generator.write(this.to);
        }
        if (this.fromAsString != null) {
            generator.writeKey("from_as_string");
            generator.write(this.fromAsString);
        }
        if (this.toAsString != null) {
            generator.writeKey("to_as_string");
            generator.write(this.toAsString);
        }
        if (this.key != null) {
            generator.writeKey("key");
            generator.write(this.key);
        }
    }

    protected static void setupRangeBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::from, JsonpDeserializer.doubleDeserializer(), "from");
        op.add(Builder::to, JsonpDeserializer.doubleDeserializer(), "to");
        op.add(Builder::fromAsString, JsonpDeserializer.stringDeserializer(), "from_as_string");
        op.add(Builder::toAsString, JsonpDeserializer.stringDeserializer(), "to_as_string");
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RangeBucket> {
        @Nullable
        private Double from;
        @Nullable
        private Double to;
        @Nullable
        private String fromAsString;
        @Nullable
        private String toAsString;
        @Nullable
        private String key;

        public final Builder from(@Nullable Double value) {
            this.from = value;
            return this;
        }

        public final Builder to(@Nullable Double value) {
            this.to = value;
            return this;
        }

        public final Builder fromAsString(@Nullable String value) {
            this.fromAsString = value;
            return this;
        }

        public final Builder toAsString(@Nullable String value) {
            this.toAsString = value;
            return this;
        }

        public final Builder key(@Nullable String value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RangeBucket build() {
            this._checkSingleUse();
            return new RangeBucket(this);
        }
    }
}

