/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FiltersAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final Buckets<Query> filters;
    @Nullable
    private final Boolean otherBucket;
    @Nullable
    private final String otherBucketKey;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<FiltersAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FiltersAggregation::setupFiltersAggregationDeserializer);

    private FiltersAggregation(Builder builder) {
        super(builder);
        this.filters = builder.filters;
        this.otherBucket = builder.otherBucket;
        this.otherBucketKey = builder.otherBucketKey;
        this.keyed = builder.keyed;
    }

    public static FiltersAggregation of(Function<Builder, ObjectBuilder<FiltersAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Filters;
    }

    @Nullable
    public final Buckets<Query> filters() {
        return this.filters;
    }

    @Nullable
    public final Boolean otherBucket() {
        return this.otherBucket;
    }

    @Nullable
    public final String otherBucketKey() {
        return this.otherBucketKey;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.filters != null) {
            generator.writeKey("filters");
            this.filters.serialize(generator, mapper);
        }
        if (this.otherBucket != null) {
            generator.writeKey("other_bucket");
            generator.write(this.otherBucket);
        }
        if (this.otherBucketKey != null) {
            generator.writeKey("other_bucket_key");
            generator.write(this.otherBucketKey);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed);
        }
    }

    protected static void setupFiltersAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::filters, Buckets.createBucketsDeserializer(Query._DESERIALIZER), "filters");
        op.add(Builder::otherBucket, JsonpDeserializer.booleanDeserializer(), "other_bucket");
        op.add(Builder::otherBucketKey, JsonpDeserializer.stringDeserializer(), "other_bucket_key");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FiltersAggregation> {
        @Nullable
        private Buckets<Query> filters;
        @Nullable
        private Boolean otherBucket;
        @Nullable
        private String otherBucketKey;
        @Nullable
        private Boolean keyed;

        public final Builder filters(@Nullable Buckets<Query> value) {
            this.filters = value;
            return this;
        }

        public final Builder filters(Function<Buckets.Builder<Query>, ObjectBuilder<Buckets<Query>>> fn) {
            return this.filters(fn.apply(new Buckets.Builder()).build());
        }

        public final Builder otherBucket(@Nullable Boolean value) {
            this.otherBucket = value;
            return this;
        }

        public final Builder otherBucketKey(@Nullable String value) {
            this.otherBucketKey = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FiltersAggregation build() {
            this._checkSingleUse();
            return new FiltersAggregation(this);
        }
    }
}

