/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.SingleMetricAggregateBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DerivativeAggregate
extends SingleMetricAggregateBase
implements AggregateVariant {
    @Nullable
    private final Double normalizedValue;
    @Nullable
    private final String normalizedValueAsString;
    public static final JsonpDeserializer<DerivativeAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DerivativeAggregate::setupDerivativeAggregateDeserializer);

    private DerivativeAggregate(Builder builder) {
        super(builder);
        this.normalizedValue = builder.normalizedValue;
        this.normalizedValueAsString = builder.normalizedValueAsString;
    }

    public static DerivativeAggregate of(Function<Builder, ObjectBuilder<DerivativeAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Derivative;
    }

    @Nullable
    public final Double normalizedValue() {
        return this.normalizedValue;
    }

    @Nullable
    public final String normalizedValueAsString() {
        return this.normalizedValueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.normalizedValue != null) {
            generator.writeKey("normalized_value");
            generator.write(this.normalizedValue);
        }
        if (this.normalizedValueAsString != null) {
            generator.writeKey("normalized_value_as_string");
            generator.write(this.normalizedValueAsString);
        }
    }

    protected static void setupDerivativeAggregateDeserializer(ObjectDeserializer<Builder> op) {
        SingleMetricAggregateBase.setupSingleMetricAggregateBaseDeserializer(op);
        op.add(Builder::normalizedValue, JsonpDeserializer.doubleDeserializer(), "normalized_value");
        op.add(Builder::normalizedValueAsString, JsonpDeserializer.stringDeserializer(), "normalized_value_as_string");
    }

    public static class Builder
    extends SingleMetricAggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DerivativeAggregate> {
        @Nullable
        private Double normalizedValue;
        @Nullable
        private String normalizedValueAsString;

        public final Builder normalizedValue(@Nullable Double value) {
            this.normalizedValue = value;
            return this;
        }

        public final Builder normalizedValueAsString(@Nullable String value) {
            this.normalizedValueAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DerivativeAggregate build() {
            this._checkSingleUse();
            return new DerivativeAggregate(this);
        }
    }
}

