/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SharedContainerGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.SharedContainer> {

	public SharedContainerGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.SharedContainer deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.SharedContainer ret = new net.bluemind.core.container.model.SharedContainer();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.SharedContainer ret, JSONObject json) {
		JSONValue sharedJSON = json.get("shared");
		ret.shared =  new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().deserialize(sharedJSON);
		JSONValue givenRightsJSON = json.get("givenRights");
		ret.givenRights =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).deserialize(givenRightsJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.SharedContainer ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("shared")) {
			JSONValue sharedJSON = json.get("shared");
			ret.shared =  new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().deserialize(sharedJSON);
		}
		if (!childPropertiesToIgnore.contains("givenRights")) {
			JSONValue givenRightsJSON = json.get("givenRights");
			ret.givenRights =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).deserialize(givenRightsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.SharedContainer o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.SharedContainer o, JSONObject ret) {

		ret.put("shared",  new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().serialize( o.shared ));
		ret.put("givenRights",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( o.givenRights ));
	}

	public void serializeTo(net.bluemind.core.container.model.SharedContainer o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("shared")) {
			ret.put("shared",  new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().serialize( o.shared ));
		}
		if (!childPropertiesToIgnore.contains("givenRights")) {
			ret.put("givenRights",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( o.givenRights ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}