/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.container.model.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsCountFastPath extends JavaScriptObject {

	protected JsCountFastPath() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsCountFastPath TOTAL()
	/*-{
		return "TOTAL";
	}-*/;

	public static final native JsCountFastPath TOTAL_VISIBLE()
	/*-{
		return "TOTAL_VISIBLE";
	}-*/;

	public static final native JsCountFastPath SOFT_DELETES()
	/*-{
		return "SOFT_DELETES";
	}-*/;

	public static final native JsCountFastPath UNSEEN_VISIBLE()
	/*-{
		return "UNSEEN_VISIBLE";
	}-*/;

	public static final native JsCountFastPath UNSEEN_TOTAL()
	/*-{
		return "UNSEEN_TOTAL";
	}-*/;

	public static final JsCountFastPath create(net.bluemind.core.container.model.CountFastPath value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case TOTAL:
				return TOTAL();
			case TOTAL_VISIBLE:
				return TOTAL_VISIBLE();
			case SOFT_DELETES:
				return SOFT_DELETES();
			case UNSEEN_VISIBLE:
				return UNSEEN_VISIBLE();
			case UNSEEN_TOTAL:
				return UNSEEN_TOTAL();
			default:
				return null;
			}
		}
	}
}