/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ItemChangelogSupportGwtEndpoint implements net.bluemind.core.container.api.IItemChangelogSupportAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ItemChangelogSupportGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public ItemChangelogSupportGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void itemChangelog(String uid, Long since, final AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler) {
		String postUri = "/{uid}/_itemchangelog";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.LONG.serialize( since);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemChangelog>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemChangelog handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemChangelogGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.core.container.api.IItemChangelogSupportPromise promiseApi() {
		return new ItemChangelogSupportEndpointPromise(this);
	}
}
