/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class ContainersSockJsEndpoint implements net.bluemind.core.container.api.IContainersAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public ContainersSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/containers/_manage";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public ContainersSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void all(net.bluemind.core.container.api.ContainerQuery query, final AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>> handler) {
		String postUri = "/_list";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.api.gwt.serder.ContainerQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ContainerDescriptor>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ContainerDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void allForUser(String domainUid, String userUid, net.bluemind.core.container.api.ContainerQuery query, final AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>> handler) {
		String postUri = "/_listforuser";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("domainUid", URL.encodeQueryString(""+domainUid));
		params.put("userUid", URL.encodeQueryString(""+userUid));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.api.gwt.serder.ContainerQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ContainerDescriptor>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ContainerDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void allLight(net.bluemind.core.container.api.ContainerQuery query, final AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>> handler) {
		String postUri = "/_listLight";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.api.gwt.serder.ContainerQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.BaseContainerDescriptor>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.BaseContainerDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void create(String uid, net.bluemind.core.container.model.ContainerDescriptor descriptor, final AsyncHandler<net.bluemind.core.container.model.BaseContainerDescriptor> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer().serialize( descriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.BaseContainerDescriptor>(handler) {
					@Override
			protected net.bluemind.core.container.model.BaseContainerDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void exists(String containerUid, final AsyncHandler<Boolean> handler) {
		String postUri = "/_exists";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( containerUid);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Boolean>(handler) {
					@Override
			protected Boolean handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.BOOLEAN.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void get(String uid, final AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ContainerDescriptor>(handler) {
					@Override
			protected net.bluemind.core.container.model.ContainerDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getAccessControlLists(List<String> containerIds, final AsyncHandler<Map<String,List<net.bluemind.core.container.model.acl.AccessControlEntry>>> handler) {
		String postUri = "/_macl";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( containerIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Map<String,List<net.bluemind.core.container.model.acl.AccessControlEntry>>>(handler) {
					@Override
			protected Map<String,List<net.bluemind.core.container.model.acl.AccessControlEntry>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getContainers(List<String> containerIds, final AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>> handler) {
		String postUri = "/_mget";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( containerIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ContainerDescriptor>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ContainerDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getContainersLight(List<String> containerIds, final AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>> handler) {
		String postUri = "/_mgetLight";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( containerIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.BaseContainerDescriptor>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.BaseContainerDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getForUser(String domainUid, String userUid, String uid, final AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler) {
		String postUri = "/_forUser";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("domainUid", URL.encodeQueryString(""+domainUid));
		params.put("userUid", URL.encodeQueryString(""+userUid));
		params.put("uid", URL.encodeQueryString(""+uid));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ContainerDescriptor>(handler) {
					@Override
			protected net.bluemind.core.container.model.ContainerDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getIfPresent(String uid, final AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler) {
		String postUri = "/_ifPresent/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ContainerDescriptor>(handler) {
					@Override
			protected net.bluemind.core.container.model.ContainerDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getLight(String uid, final AsyncHandler<net.bluemind.core.container.model.BaseContainerDescriptor> handler) {
		String postUri = "/_light/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.BaseContainerDescriptor>(handler) {
					@Override
			protected net.bluemind.core.container.model.BaseContainerDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getLightIfPresent(String uid, final AsyncHandler<net.bluemind.core.container.model.BaseContainerDescriptor> handler) {
		String postUri = "/_ifPresentLight/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.BaseContainerDescriptor>(handler) {
					@Override
			protected net.bluemind.core.container.model.BaseContainerDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void setAccessControlList(String uid, List<net.bluemind.core.container.model.acl.AccessControlEntry> entries, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/_acl";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( entries);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void update(String uid, net.bluemind.core.container.model.ContainerModifiableDescriptor descriptor, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ContainerModifiableDescriptorGwtSerDer().serialize( descriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.core.container.api.IContainersPromise promiseApi() {
		return new ContainersEndpointPromise(this);
	}

}
