/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ContainerManagementEndpointPromise implements net.bluemind.core.container.api.IContainerManagementPromise {

	private net.bluemind.core.container.api.IContainerManagementAsync impl;

	public ContainerManagementEndpointPromise(net.bluemind.core.container.api.IContainerManagementAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> allowOfflineSync(String subject  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allowOfflineSync(subject,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Boolean> canAccess(List<String> verbsOrRoles  ) {
		
		CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
		AsyncHandler<Boolean> handler = new AsyncHandler<Boolean>() {
			public void success(Boolean value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.canAccess(verbsOrRoles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.PermittedVerbs> canAccessVerbs(List<String> verbsOrRoles  ) {
		
		CompletableFuture<net.bluemind.core.container.api.PermittedVerbs> ret = new CompletableFuture<net.bluemind.core.container.api.PermittedVerbs>();
		AsyncHandler<net.bluemind.core.container.api.PermittedVerbs> handler = new AsyncHandler<net.bluemind.core.container.api.PermittedVerbs>() {
			public void success(net.bluemind.core.container.api.PermittedVerbs value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.canAccessVerbs(verbsOrRoles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> disallowOfflineSync(String subject  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.disallowOfflineSync(subject,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>> getAccessControlList() {
		
		CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>> ret = new CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>>();
		AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>> handler = new AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>>() {
			public void success(List<net.bluemind.core.container.model.acl.AccessControlEntry> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAccessControlList( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemDescriptor>> getAllItems() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.ItemDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAllItems( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> getDescriptor() {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor>();
		AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor>() {
			public void success(net.bluemind.core.container.model.ContainerDescriptor value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getDescriptor( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Count> getItemCount() {
		
		CompletableFuture<net.bluemind.core.container.api.Count> ret = new CompletableFuture<net.bluemind.core.container.api.Count>();
		AsyncHandler<net.bluemind.core.container.api.Count> handler = new AsyncHandler<net.bluemind.core.container.api.Count>() {
			public void success(net.bluemind.core.container.api.Count value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getItemCount( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemDescriptor>> getItems(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.ItemDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getItems(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Map<String,String>> getSettings() {
		
		CompletableFuture<Map<String,String>> ret = new CompletableFuture<Map<String,String>>();
		AsyncHandler<Map<String,String>> handler = new AsyncHandler<Map<String,String>>() {
			public void success(Map<String,String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSettings( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setAccessControlList(List<net.bluemind.core.container.model.acl.AccessControlEntry> entries  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setAccessControlList(entries,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setPersonalSettings(Map<String,String> settings  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setPersonalSettings(settings,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setSetting(String key ,  String value  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setSetting(key, value,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setSettings(Map<String,String> settings  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setSettings(settings,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> subscribers() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.subscribers( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(net.bluemind.core.container.model.ContainerModifiableDescriptor descriptor  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(descriptor,  handler);
		return ret;
	}

}
