import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './VideoConferenceUidsClient.json';

export class VideoConferenceUidsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/videoconferencing/uids');
    }
    async getProviderTypeUid( __fetchOptions = {}) {
        let __path = this.base + '/provider_type';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getResourceTypeUid( __fetchOptions = {}) {
        let __path = this.base + '/resource_type_uid';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
