
import { User } from "./User"; 
import { ChangePassword } from "./ChangePassword"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { 
    BaseDirEntry
} from "@bluemind/directory.api";
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { 
    Group
} from "@bluemind/group.api";
import { 
    VCard
} from "@bluemind/addressbook.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * {@link User} API. {domainUid} corresponds to the fully qualified domain name
 */
export interface IUser {
    /**
     * Retrieve all existing {@link User} uids
     * @returns a list of all existing {@link User} uids
     */
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Fetches a {@link User} by its email
     * @param email the user's email
     * @returns the user item value, or null if the user does not exist
     */
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    /**
     * Fetches a {@link User} by its external id
     * @returns the user item value, or null if the user does not exist
     */
    byExtId(extid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    /**
     * Fetches a {@link User} by its login
     * @param login the user's login
     * @returns the user item value, or null if the user does not exist
     */
    byLogin(login: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    /**
     * Creates a new {@link User} with the given uid. Also creates default calendar,
     * todo elements and the {@link User}'s mailbox if routing is internal
     * @param uid the user's unique id
     * @param user user data
     */
    create(uid: string, user?: User,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Creates a new {@link User} with the given uid. Associates an external id to
     * the {@link User}
     * @param uid the user's unique id
     * @param user user data
     */
    createWithExtId(uid: string, extid: string, user?: User,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Deletes a {@link User}. Also deletes all user related objects and the user's
     * mailbox
     * @param uid the user's unique id
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deletePhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Toggle advanced per user logging for the specified product
     * @param userUid user's unique id
     * @param endpoint endpoint name (IMAP,MAPI,POP3)
     * @param enable 
     */
    enablePerUserLog(userUid: string, endpoint: string, enable?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetches a {@link User} by its unique id
     * @param uid the user's unique id
     * @returns the user item value, or null if the user does not exist
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Fetches a {@link User} by its unique id, without vcard or mailbox
     */
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    /**
     * Get {@link User} locale
     * @returns the locale language value
     */
    getLocale(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Fetches a list of User
     * @param uids the user's unique ids
     * @returns the list of users
     */
    getMultipleVcardOnly(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<User>>>;
    getPhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Retrieves a list of all roles owned by a {@link User}. Also includes roles
     * indirectly assigned to the {@link User}, for example by its
     * {@link net.bluemind.group.api.Group} memberships
     * @param uid the user's unique id
     * @returns a list of roles
     */
    getResolvedRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Retrieves a list of all roles directly owned by a {@link User}
     * @returns a list of roles
     */
    getRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Retrieves a list of all {@link User}s owning all of the provided roles
     * @param roles a list of roles
     * @returns a list of users owning all provided roles
     * @deprecated 
     */
    getUsersWithRoles(roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Retrieves a {@link User}'s contact informations
     * ({@link net.bluemind.addressbook.api.VCard})
     * @param uid user's unique id
     * @returns the user's contact informations
     */
    getVCard(uid: string,  __fetchOptions?: RequestOptions): Promise<VCard>;
    memberOf(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    memberOfGroups(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    setExtId(uid: string, arg1?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update a {@link User}'s password
     * @param uid user's unique id
     * @param password object containing the current and new password
     */
    setPassword(uid: string, password?: ChangePassword,  __fetchOptions?: RequestOptions): Promise<void>;
    setPhoto(uid: string, arg1?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Sets the {@link User}'s roles. Replaces all existing role assignments
     * @param uid the user's unique id
     * @param roles a set of roles to be assigned to the user
     */
    setRoles(uid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modifies an existing {@link User}
     * @param uid the user's unique id
     * @param user the new user values
     */
    update(uid: string, user?: User,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modifies a {@link User}'s {@link net.bluemind.directory.api.AccountType}
     * @param uid user's unique id
     * @param accountType the new account type
     */
    updateAccountType(uid: string, accountType?: BaseDirEntry.AccountType,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Updates a {@link User}'s contact informations
     * @param uid user's unique id
     * @param userVCard the new contact informations
     */
    updateVCard(uid: string, userVCard?: VCard,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class UserClient extends ApiEndPoint implements IUser {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    byExtId(extid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    byLogin(login: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    create(uid: string, user?: User,  __fetchOptions?: RequestOptions): Promise<void>;
    createWithExtId(uid: string, extid: string, user?: User,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deletePhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    enablePerUserLog(userUid: string, endpoint: string, enable?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<User>>;
    getLocale(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMultipleVcardOnly(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<User>>>;
    getPhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getResolvedRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getUsersWithRoles(roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getVCard(uid: string,  __fetchOptions?: RequestOptions): Promise<VCard>;
    memberOf(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    memberOfGroups(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    setExtId(uid: string, arg1?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    setPassword(uid: string, password?: ChangePassword,  __fetchOptions?: RequestOptions): Promise<void>;
    setPhoto(uid: string, arg1?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    setRoles(uid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, user?: User,  __fetchOptions?: RequestOptions): Promise<void>;
    updateAccountType(uid: string, accountType?: BaseDirEntry.AccountType,  __fetchOptions?: RequestOptions): Promise<void>;
    updateVCard(uid: string, userVCard?: VCard,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
